/*
 * test.c
 * based on sample-control-container.c
 * 
 * Authors:
 *   Nat Friedman  (nat@helixcode.com)
 *   Michael Meeks (michael@helixcode.com)
 *
 * Copyright 1999, 2000 Helix Code, Inc.
 */
#include <config.h>
#include <gnome.h>
#include <liboaf/liboaf.h>
#include <bonobo.h>

static gchar    *hname = NULL;
static gchar    *rcom  = NULL;
static gchar    *wcom  = NULL;
poptContext      pctx;

struct poptOption options[] = {
  { "hostname", '\0', POPT_ARG_STRING, &hname, 0,
    N_("Hostname to be used for MIB browser control"), "HOSTNAME" },
  { "rcom", '\0', POPT_ARG_STRING, &rcom, 0,
    N_("Read community name to be used for MIB browser control"), "RCOM" },
  { "wcom", '\0', POPT_ARG_STRING, &wcom, 0,
    N_("Write community name to be used for MIB browser control"), "WCOM" },
  { NULL, '\0', 0, NULL, 0 }
};

static void
app_destroy_cb (GtkWidget *app, BonoboUIHandler *uih)
{
	bonobo_object_unref (BONOBO_OBJECT (uih));

	gtk_main_quit ();
	/*g_warning ("Main level %d\n", gtk_main_level ());*/
}

static int
app_delete_cb (GtkWidget *widget, GdkEvent *event, gpointer dummy)
{
	gtk_widget_destroy (GTK_WIDGET (widget));
	return FALSE;
}

static guint
container_create (void)
{
	GtkWidget       *app;
	GtkWidget       *control;
	GtkWindow	*window;
	BonoboUIHandler *uih;

	app = gnome_app_new ("gxsnmp-test-control-container",
			     "GxSNMP Test control container");

	window = GTK_WINDOW (app);

	uih = bonobo_ui_handler_new ();

	gtk_window_set_default_size (window, 500, 440);
	gtk_window_set_policy (window, TRUE, TRUE, FALSE);

	gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		GTK_SIGNAL_FUNC (app_delete_cb), NULL);

	gtk_signal_connect (GTK_OBJECT (window), "destroy",
		GTK_SIGNAL_FUNC (app_destroy_cb), uih);

	bonobo_ui_handler_set_app (uih, GNOME_APP (app));
	bonobo_ui_handler_create_menubar (uih);

	control = bonobo_widget_new_control (
		"OAFIID:gxsnmp-mib_browser:0de36838-8168-49cc-bea6-2f34a7c98800",
		bonobo_object_corba_objref (BONOBO_OBJECT (uih)));

	gnome_app_set_contents (GNOME_APP (app), control);
	gtk_widget_show_all (app);

	if (hname)
		bonobo_widget_set_property ((BonoboWidget *)control,
					    "hostname", hname, NULL);
	if (rcom)
		bonobo_widget_set_property ((BonoboWidget *)control,
					    "rcom", rcom, NULL);
	if (wcom)
		bonobo_widget_set_property ((BonoboWidget *)control,
					    "wcom", wcom, NULL);
	return FALSE;
}

int
main (int argc, char **argv)
{
	CORBA_Environment ev;
	CORBA_ORB orb;

	CORBA_exception_init (&ev);

	gnome_init_with_popt_table ("gxsnmp-test-control-container", "1.0", 
		argc, argv, options, 0, &pctx);
	poptFreeContext (pctx);

	orb = oaf_init (argc, argv);


	if (bonobo_init (orb, NULL, NULL) == FALSE)
		g_error ("Could not initialize Bonobo\n");

	/*
	 * We can't make any CORBA calls unless we're in the main
	 * loop.  So we delay creating the container here.
	 */
	gtk_idle_add ((GtkFunction) container_create, NULL);

	bonobo_main ();

	return 0;
}
