/* -*- Mode: C -*-
 *  $Id: gxsnmp_database_table.h,v 1.1 2000/09/20 21:20:51 gregm Exp $
 *  GXSNMP - An snmp management application
 *
 *  Copyright 2000 Gregory McLean and others.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 */
#ifndef _GXSNMP_DB_TABLES_H__
#define _GXSNMP_DB_TABLES_H__

/**
 * gxsnmp_db_table_descriptor
 *
 **/
typedef struct _gxsnmp_db_table_descriptor {
  gchar         *name;
  guint         size;
  GList         *fields;
} gxsnmp_db_table_descriptor;

/**
 * GXSNMP_DB_FIELD_TYPES
 *
 **/
typedef enum {
  TD_GUINT = 1,
  TD_GINT,
  TD_GSTR,
  TD_PGUINT,
  TD_PGINT,
  TD_PGSTR,
  TD_PGL,
  TD_GDOUBLE,
  TD_PGDOUBLE
} GxSNMP_DB_FIELD_TYPE;

/**
 * gxsnmp_db_field_descriptor
 *
 **/
typedef struct _gxsnmp_db_field_descriptor {
  gchar         *name;
  guchar        type;
  guint         offset;
} gxsnmp_db_field_descriptor;

/****************************************************************************
 * Public functions.
 **/
gint                gxsnmp_db_field_offset  (gxsnmp_db_table_descriptor *table,
					     gchar                      *name);
gint                gxsnmp_db_field_type    (gxsnmp_db_table_descriptor *table,
					     gchar                      *name);
gxsnmp_db_table_descriptor *gxsnmp_db_find_table (const gchar           *name);

#endif



