/* trap.d
 *
 */
#include <stddef.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/wait.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <glib.h>
#include <netinet/in.h>

#include "dae.h"

int debug_level;

char version[] = "$Id: trapd.c,v 1.6 2000/07/23 01:08:28 remlali Exp $"; /*usefull to 'strings' the binary*/
char trapd[] = "trapd";
glb_enviroment enviroment;
aclist *trapfilter;
char pipestring[4000];		/*minimum support of 484 bytes in a TRAP-PDU (rfc 1157)*/
FILE *fptrapd;

/* to be obsoleted */
//trapslot trap;			/*this is the incoming trap mem space*/

void debug(){};

int trap_command(char *cmd, char **args){	/*runs command using fork and system calls*/
pid_t pid;	

  if(!(pid = fork())){
    if(!(fork())) execv(cmd,args);
    _exit(0);
  }
  waitpid(pid,NULL,0);
  return 0;
}

void reload_config(){
  free(enviroment.traptab);
  load_trapconf();
  logstr(fptrapd,"Reloaded trap.conf.\n");
}

void coredump(){
pid_t pid;
  logstr(fptrapd,"Administratively coredumped.\n");
  if(!(pid = fork())){
    raise(SIGQUIT);
    _exit(0); /*precausious if SIGQUIT has other purpouses on other machines*/
  }
  waitpid(pid,NULL,0);
}

int main(){
gint i, j, c, k, l, a, trapdsock, nbytes, *args[10];
char foo[80],foo2[80], eid[512], row[200], cmd[200];
gint pdutype;
gint netmon_host, netmon_msg;
struct in_addr netmon_addr;
gchar *netmon_ip;
g_trap trap;
g_trap_context trap_ctx;

/********/
typedef struct _trapbuf {
  gint type;
  gint severity;
  guint time;
  struct sockaddr_in address;
  guint generic;
  guint specific;
  gint  oidlen;
  gchar oid[130];
  gchar argbuf[10000];
} trapbuf;

trapbuf *gtrap;
/********/


/*follows are some temporary variables to parse new trap format:block*/
int severity;	/*hold where in trap block to insert severity */


/*daemonize*/
#if 0
  if(fork() != 0) _exit(0);
  if(setsid() == -1) _exit(0);
  if(fork() != 0) _exit(0);
  umask(777);
  if(chdir("/")<0) _exit(0);
  for(i=sysconf(_SC_OPEN_MAX),j=0;j<i;) close(j++);
  open("/dev/null",O_RDWR); dup(0); dup(0);
#endif

  load_enviroment();
fprintf(stderr,"1");
  fptrapd = logopen("trapd.log");
  load_trapconf();
fprintf(stderr,"2");
  unlink(enviroment.trapd);
  if(!(trapdsock = createsocket(enviroment.trapd,0))) _exit(0);
//  signal(SIGHUP, reload_config);
//  signal(SIGINT, coredump);
  logstr(fptrapd,"Trapd started.\n");


start:
  memset(pipestring,'\0',4000);	/* due to a buggy block protocol, should now be safe to remove? */
  nbytes = recv(trapdsock,pipestring,400,0);

  pdutype = (gint) pipestring[3];
  fprintf(stderr,"pdutype(%u)\n", pdutype);
  switch(pdutype){
  case PDU_KILL:
    close(trapdsock);
    unlink(enviroment.trapd);
    logstr(fptrapd,"Trapd stoped.\n");
    fclose(fptrapd);
    _exit(0);
  break;
  case PDU_STATUS:
    nbytes = PDU_STATUS_REPLY;
    memcpy(eid, &nbytes, sizeof(gint));
    strcpy(eid+sizeof(gint),"trapd");
    nbytes = sizeof(gint) + sizeof("trapd")+1;
    senddsocket(trapdsock, enviroment.gxdhd, eid, nbytes);
  break;
  case PDU_RELOAD:
    reload_config();
  break;
  case PDU_NETMON:
    memcpy(&netmon_msg, pipestring+sizeof(gint), sizeof(gint));
    memcpy(&netmon_host, pipestring+sizeof(gint)*2, sizeof(gint));
    memcpy(&netmon_addr, pipestring+sizeof(gint)*3, sizeof(gint));
    netmon_ip = inet_ntoa(netmon_addr);
    fprintf(stderr, "Host %d, IP %s, msg %u\n", netmon_host, netmon_ip, netmon_msg);
    senddsocket(trapdsock, enviroment.evdpysrvd, pipestring, nbytes);       
  break;
  case PDU_TRAP:

  memset(&trap, 0, sizeof(trapslot));
  severity = &severity;		/*set severity to non null value, obsolete?*/

  g_trap_decode(pipestring,&trap);

  gtrap = pipestring;

  fprintf(stderr,"TRAP(%s,%s,%d,%d)\n",trap.address,trap.oid, trap.g, trap.s);

  memset(&trap_ctx, 0, sizeof(g_trap_context));
  if(g_trap_lookup(&trap, &trap_ctx)){					/*Do some action if trap is identified in trap.conf*/
    severity = 5 + sizeof(char);

    gtrap->severity = trap.severity;	/*set severity in trap block to forward*/

    if(strlen(trap_ctx.popup)){ 					/*POPUP a message to DISPLAY*/
      var_interpret(row, trap_ctx.popup, 200, &trap);
      if(enviroment.popup_date) args[0] = ctime((time_t *)&trap.timestamp);
      else args[0] = trapd;
      args[1] = row;
      args[2] = 0;
      trap_command(enviroment.popup_exec,args);
    }
    if(strlen(trap_ctx.script)){
      wordcpy(cmd,trap_ctx.script,1);				/*get command*/
      wordcpy(eid,trap_ctx.script,2);				/*get command arguments*/
      var_interpret(row,eid,200,&trap);
      j=0;i=0;
      args[j++] = trapd;					/*set program name, script's $0*/
      args[j++] = row;
      for(;9>j;i++){
        if(row[i] == '\0') break;
        if(row[i] == ' '){
          row[i] = '\0';
          args[j++] = &row[i+1];
        }
      }
      args[j] = 0;
      trap_command(cmd,args);
    }

    if(trap.flag & 1){				/*bit 0 is forward to corrd*/
      senddsocket(trapdsock, enviroment.corrd, pipestring, nbytes);       	/*forward event to corrd*/
    }
    if(trap.flag & 2){				/*bit 1 is forward to evdpysrvd*/
      senddsocket(trapdsock, enviroment.evdpysrvd, pipestring, nbytes);       /*forward event to event display server deamon*/
    }
    if(trap.flag & 4){				/*bit 2 log trap*/
      g_snprintf(eid,512,"Trap: %s#%s#%d#%d\n",trap.address,trap.oid,trap.g,trap.s);
      logstr(fptrapd,eid);
    }
  }else{					/*this code is for unknown traps */
    trap.severity = enviroment.severity;
    if(enviroment.trapd_unknown_traps){		/*may I forward unknown traps to evdpysrvd*/
      senddsocket(trapdsock, enviroment.evdpysrvd, pipestring, nbytes);       /*forward event to event display server deamon*/
    }
    if(enviroment.trapd_log_unknown_traps){
      fprintf(stderr,"log unknown trap\n");
      g_snprintf(eid,512,"Trap: %s#%s#%d#%d\n",trap.address,trap.oid,trap.g,trap.s);
      logstr(fptrapd,eid);
    }
  }
/*lets do some actions for both unknown and identified traps*/

  break;
  default:
  /* unknown PDU_TYPE */
  break;
  }/* end of while pdutype */
  goto start;
}
