/* event handling system, general library
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <glib.h>

#include <errno.h>
#include <fcntl.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/un.h>
#include <netinet/in.h>   
#include <arpa/inet.h>
#include <unistd.h>

#include "g_snmp.h"

#include "dae.h"

char libdae_version[] = "$Id: dae.c,v 1.4 2000/07/23 01:08:28 remlali Exp $"; /*usefull to 'strings' the binary*/

struct sockaddr_in ddserver;

extern glb_enviroment enviroment;
extern aclist *trapfilter;

extern void debug();

char *load_file(char *filename)
{
char *text;
FILE *fp;
struct stat statb;

	if(!filename || !*filename){
		fprintf(stderr,"Empty filename");
		return 0;
	}

	if (stat(filename, &statb) == -1 || 
	    (statb.st_mode & S_IFMT) != S_IFREG || 
	    !(fp = fopen(filename, "r")))
	  {
	    if((statb.st_mode & S_IFMT) == S_IFREG) 
	      perror(filename);
	    else 
	      fprintf(stderr,"%s: not a regular file\n",filename);
	    return 0;
	}
	if (!( statb.st_size )) 
	  { 
	    text = (char *) NULL;
	    fclose(fp); 
	    return NULL;
	  }
	if (!(text = (char *) g_malloc((unsigned)(statb.st_size+1))))
	  {
	    fprintf(stderr, "Can't allocate enough memory\n");
	    fclose(fp); 
	    return 0;
	  }
	if (!fread(text, sizeof(char), statb.st_size+1, fp))
	  {
	    fprintf(stderr, "Couldn't read file\n");
	    g_free(text);
	    fclose(fp);
	    return 0;
	  }
	text[statb.st_size] = 0;
	fclose(fp);
	return text;
}

/****************************************************************************
 * SNMP Functions
 ***************************************************************************/
/*
 * converts oid to a text:
 * .1.3.6.1   -->   .internet.dod.org... 
 */
int 
oid2text(char *text, char *oidtext)
{
  gulong  name[SNMP_SIZE_OBJECTID];
  guint   name_len;
  
  name_len = SNMP_SIZE_OBJECTID;
  text[0];
  oidtext[0];
/*
  if (!read_objid(oidtext, name, &name_len))
    {
      return 1; 
    }
  sprint_objid(text, 200, name, name_len);
*/
  return 0;
}

/*
 * global functions
 */

int load_enviroment(){
char line[200],entity[200],value[200];
char *env;
FILE *fp;


	env = getenv("DAE_BASE");
	if(!env) {
		fprintf(stderr,"Error: enviroment variable: DAE_BASE is not set.\n");
		exit(1); /*critical*/
	}

	enviroment.trapd_unknown_traps = 1;
	enviroment.trapd_log_unknown_traps = 1;
	enviroment.corrd_log = 1;
	enviroment.evdpysrvd_log = 1;
	enviroment.evdpysrvd_poll = 300;		/*default timeout/poll of event displays (in seconds) */
	enviroment.gxevents_max_traps = 100;		/*default number of traps gxevents will display before removing*/
	enviroment.gxevents_lookup = 1;			/*default don't lookup hostname from IP*/
        enviroment.popup_date = 0;			/*default to negative*/

        sprintf(line, "%s/conf/nb.conf", env);

	if(!(fp = fopen(line, "r"))) return 1;
while(fgets(line,200,fp)){
  if(line[0] == '#') continue;
  wordcpy(entity,line,1);		/* first check if it is a define statement */
  if(!strcmp(entity,"CORRD_LOG")) enviroment.corrd_log = 1;
  else if(!strcmp(entity,"TRAP_UNKNOWN_TRAPS")) enviroment.trapd_unknown_traps = 1;
  else if(!strcmp(entity,"TRAP_LOG_UNKNOWN_TRAPS")) enviroment.trapd_log_unknown_traps = 1;
  else if(!strcmp(entity,"EVDPYSRVD_LOG")) enviroment.evdpysrvd_log = 1;
  else if(!strcmp(entity,"POPUP_DATE"))  enviroment.popup_date = 1;
  else if(!strcmp(entity,"GXEVENTS_LOOKUP"))  enviroment.gxevents_lookup = 1;
  else {
    wordcpyt(entity,line,"=",1);
    wordcpyt(value,line,"=",2);
    restrap(value);
    if(!strcmp("DATABASE_HOST",entity)) enviroment.host = g_strdup(value);
    else if(!strcmp("DATABASE_NAME",entity)) enviroment.name = g_strdup(value);
    else if(!strcmp("DATABASE_USER",entity)) enviroment.user = g_strdup(value);
    else if(!strcmp("DATABASE_PASS",entity)) enviroment.passwd  = g_strdup(value);
    else if(!strcmp("BASE",entity))          enviroment.base  = g_strdup(value);
    else if(!strcmp("EVDPYSRVD_POLL",entity)) enviroment.evdpysrvd_poll = atoi(value);
    else if(!strcmp("TRAP_DEFAULT_SEVERITY",entity)) enviroment.severity = atoi(value);
    else if(!strcmp("POPUP_EXEC",entity))  enviroment.popup_exec = g_strdup(value);
    else if(!strcmp("GXEVENTS_MAX_TRAPS",entity))  enviroment.gxevents_max_traps = atoi(value);
  }
}

  enviroment.actiond = g_strdup_printf("%s/sockets/actiond", enviroment.base);
  enviroment.corrd = g_strdup_printf("%s/sockets/corrd", enviroment.base);
  enviroment.crond = g_strdup_printf("%s/sockets/crond", enviroment.base);
  enviroment.evdpysrvd = g_strdup_printf("%s/sockets/evdpysrvd", enviroment.base);
  enviroment.gxdhd = g_strdup_printf("%s/sockets/gxdhd", enviroment.base);
  enviroment.pdud = g_strdup_printf("%s/sockets/pdud", enviroment.base);
  enviroment.trapd = g_strdup_printf("%s/sockets/trapd", enviroment.base);
  enviroment.netmon = g_strdup_printf("%s/sockets/netmon", enviroment.base);

  fclose(fp);
  return 0;
}

int load_trapconf(){
char line[200],foo[200];
char *filename = "./conf/trap.conf";
FILE *fp;
int i=0,f;
gchar *trapconf_file;

        trapconf_file = g_strdup_printf("%s/conf/trap.conf", enviroment.base);

	if(!(fp = fopen(trapconf_file, "r"))) return 1;
	while(fgets(line,200,fp)) i++;
	i++; i++; i++;	/*this slot is the last empty + 2 for safety*/

	if (!(enviroment.traptab = (trap_slot *) malloc((unsigned)(i*(sizeof(trap_slot)))))){
		fprintf (stderr, "Can't alloc enough space for %s", filename);
		fclose (fp);
		return 1;
	}
	fseek(fp,0,SEEK_SET);
	i=0;
	while(fgets(line,200,fp)){
		if(line[0] == '#') continue;		/*skip remarks in trap.conf*/

		enviroment.traptab[i].oid = g_strdup(wordcpy(foo, line, 1)); /* OID */

		wordcpy(foo,line,2);			/*generic*/
		f = atoi(foo);
		enviroment.traptab[i].g = f;

		wordcpy(foo,line,3);			/*specific*/
		f = atoi(foo);
		enviroment.traptab[i].s = f;

		enviroment.traptab[i].name = g_strdup(wordcpy(foo, line, 4)); /* Name */

		enviroment.traptab[i].script = g_strdup(wordcpy(foo, line, 5)); /* Script */

		enviroment.traptab[i].popup = g_strdup(wordcpy(foo, line, 6)); /* Popup */

		wordcpy(foo,line,7);			/*EID*/
		f = atoi(foo);
		enviroment.traptab[i].eid = f;

		wordcpy(foo,line,8);			/*Flags*/
		f = atoi(foo);
		enviroment.traptab[i].flag = f;

		wordcpy(foo,line,9);			/*Severity*/
		f = atoi(foo);
		enviroment.traptab[i].severity = f;

		i++;
	}
	enviroment.traptab[i].oid = 0;		/*Terminate*/
	fclose(fp);
        g_free(trapconf_file);
	return 0;
}
corr_slot *load_corrconf(){
char line[200],foo[200];
char *filename = "./conf/corr.conf";
FILE *fp;
int i=0;
corr_slot *corret, *cortmp;
gchar *correlation_file;

        correlation_file = g_strdup_printf("%s/conf/corr.conf", enviroment.base);

	if(!(fp = fopen(correlation_file,"r"))) return 1;
	while(fgets(line,200,fp)) i++;
	i++; i++; i++;

	if (!(corret = (corr_slot *) malloc((unsigned)(i*(sizeof(corr_slot)))))){
		fprintf (stderr, "Can't alloc enough space for %s", filename);
		fclose (fp);
		return 1;
	}
	fseek(fp,0,SEEK_SET);
	cortmp = corret;
	while(fgets(line,200,fp)){
		if(line[0] == '#') continue;
                corret->mask = g_strdup(wordcpy(foo,line,1)); /* IP-mask */
                corret->file = g_strdup(wordcpy(foo,line,2)); /* correlation file */
		corret++;
	}
	corret->file[0] = 0;
	fclose(fp);
        g_free(correlation_file);
	return cortmp;
}
