/*
 * GXSNMP - An snmp managment application
 * Copyright (C) 2000 Larry Liimatainen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * util.c -- mixed add on features
 */

/*
 * utility functions for the gxevents
 *
 */

#include <sys/wait.h>

#include <gnome.h>
#include "dbapi.h"
#include "gxsnmp/gxsnmp_dbapi.h"
#include "dae.h"
#include "gxevents_util.h"

extern GList *sub_windows;
extern char aclfile[200];
extern GtkWidget *tvw_win, *tvw_vbox;
extern aclist *trapfilter;
extern trapslot eventsel;
extern char line[400];
extern char textoid[400];
extern GtkWidget *fileacl;
extern GtkWidget *subfileacl;

/* menutools_interpret()
 *
 * execute a command from tools menu
 *
 */
void
menutools_interpret(GtkWidget *mti, gchar *text)
{
gchar cmd[200];
gchar ioo[80];
gchar *iarg[10];
int i=0,j=0;
pid_t pid;

  var_interpret(cmd, text, 200, &eventsel);
  wordcpy(ioo,cmd,1);
  iarg[j++] = ioo;
  for(;9>j;i++){
    if(cmd[i] == '\0') break;
    if(cmd[i] == ' '){
      cmd[i] = '\0';
      iarg[j++] = &cmd[i+1];
    }
  }
  iarg[j] = 0;
  if(!(pid = fork())){
    if(!(fork())) execv(ioo,iarg);
      _exit(0);
    }
  waitpid(pid,NULL,0);
}

void
tvw_close(GtkWidget *tvw)
{
  gtk_widget_destroy(tvw);
}

/* tvw_open()
 *
 * send selected trap to a own window
 */
void
tvw_open()
{
GtkWidget *foo;

  eventsel.name[0] = 0;                                 /*define some trapslot_clear() instead*/
  trap_lookup(&eventsel);

  tvw_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  tvw_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add(GTK_CONTAINER(tvw_win), tvw_vbox);
  gtk_widget_show(tvw_vbox);

  g_snprintf(line,400,"Object ID: %s",eventsel.oid);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  textoid[0] = 0;
  oid2text(textoid, eventsel.oid);
  g_snprintf(line,400,"Object ID: %s",textoid);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  g_snprintf(line,400,"Generic: %d",eventsel.g);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  g_snprintf(line,400,"Specific: %d",eventsel.s);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  g_snprintf(line,400,"Name: %s",eventsel.name);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  g_snprintf(line,400,"Source: %s",eventsel.IP);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  g_snprintf(line,400,"Severity: %d",eventsel.severity);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  foo = gtk_label_new(eventsel.argoid[0]);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  g_snprintf(line,400,"Date: %s", ctime((time_t *)&eventsel.timestamp));
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  foo = gtk_button_new_with_label("Dismiss");
  gtk_signal_connect(GTK_OBJECT(foo), "clicked",GTK_SIGNAL_FUNC(tvw_close),NULL);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  gtk_widget_show_all(tvw_win);
}

/* sub_close()
 *
 * 
 *
 */
void
sub_close(GtkWidget *win)
/*I wonder if win is the dismiss button widget, then for(;;) beneith is unecessery*/
{ 
GList *swgl;
sub_window *subwin;

  swgl = sub_windows;
  while(swgl){
    subwin = swgl->data;
    if(subwin->win == win){
      gtk_widget_destroy(win);
      subwin->stat = SUBWIN_EMPTY;   /*this slot is set to empty, for reusage*/
      g_free(subwin->acl);
    }
    swgl = swgl->next;
  }
}

/* sub_open()
 *
 * open a sub trap display
 */
void
sub_open(sub_window *subw)
{
GtkWidget *sub_vbox;
GtkWidget *foo;
GtkWidget *mywin;

  subw->win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  sub_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add(GTK_CONTAINER(subw->win), sub_vbox);
  gtk_widget_show(sub_vbox);

  foo = gtk_label_new("Loaded filter: test");
  gtk_box_pack_start (GTK_BOX (sub_vbox), foo, FALSE, FALSE, 0);

  subw->sublist = gtk_clist_new(1);
  /*gtk_signal_connect(GTK_OBJECT(subw->sublist), "select_row",GTK_SIGNAL_FUNC(xxx_cb),NULL);*/
  gtk_clist_set_selection_mode(GTK_CLIST(subw->sublist),GTK_SELECTION_SINGLE);
  gtk_clist_column_titles_hide(GTK_CLIST(subw->sublist));
  gtk_clist_set_column_width(GTK_CLIST(subw->sublist),0,200);

  mywin = gtk_scrolled_window_new(0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (mywin),  GTK_POLICY_ALWAYS,  GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (mywin), subw->sublist);
  gtk_box_pack_start (GTK_BOX (sub_vbox), mywin, FALSE, FALSE, 0);

  foo = gtk_button_new_with_label("Dismiss");
  gtk_signal_connect(GTK_OBJECT(foo), "clicked",GTK_SIGNAL_FUNC(sub_close),NULL);
  gtk_box_pack_start (GTK_BOX (sub_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  gtk_widget_show_all(subw->win);
}

/* prune_trap()
 *
 * this callback will prune the selected trap.
 * add it into current loaded ACL
 */
void
prune_trap()
{ 
aclist acl;

  if(aclfile[0] == 0) return;                 /*no trapfilter loaded*/
  acl.action = 13;                            /*add 'deny oid+g+s'*/
  acl.g = eventsel.g;
  acl.s = eventsel.s;
  strcpy(acl.oid,eventsel.oid);
  acl_add_filter(acl, aclfile);
  /*reload trapfilter*/
  if(trapfilter) g_free(trapfilter);
  else fprintf(stderr,"APP_ERR: no trapfilter loaded, but aclfile is set\n");
  trapfilter = load_acl(aclfile);             /*load event display filter (trapfilter )*/
}

/* ACCESS CONTROL LIST SECTION */

/*shows up the ACL file selection box*/
void fileacl_select()
{  
  gtk_widget_show_all(fileacl);
}

/*hides ACL file selection box*/
void fileacl_hide()
{  
  gtk_widget_hide(fileacl);
}

/*only used by main trap display */
void fileacl_load(GtkWidget *w, GtkFileSelection *fs)
{ 
  strcpy(aclfile,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
  if(trapfilter) free(trapfilter);             /*free old trapfilter*/
  trapfilter = load_acl(aclfile);              /*load event display filter*/
  fileacl_hide();
}


/* SUB WINDOW SECTION */

/*shows up the ACL file selection box*/
void subfileacl_select()
{
  gtk_widget_show_all(subfileacl);
}

/*hides ACL file selection box*/
void subfileacl_hide()
{  
  gtk_widget_hide(subfileacl);
}

/*creates a new sub_window slot and loads filter */ 
void subfileacl_load(GtkWidget *w, GtkFileSelection *fs)
{ 
  sub_window *subwin;
  
  subfileacl_hide();                                  /*thank you, selection box*/
  subwin = g_malloc0(sizeof(sub_window));
  strcpy(aclfile,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));  
     /*retreive what access control 
       file to use file to load*/
  subwin->acl = load_acl(aclfile);            /*load sub windows filter*/
  subwin->stat = SUBWIN_ACTIVE;               /*set this sub window to state: used*/ 
  sub_windows = g_list_append(sub_windows, subwin);
  sub_open(subwin);                            /*create widgets*/
}

