/*
 * GXSNMP - An snmp managment application
 * Copyright (C) 2000 Larry Liimatainen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * gxevents.c -- GUI event display main
 *
 * The events & traps graphical interface
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <stddef.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include "dbapi.h"
#include "gxsnmp/gxsnmp_dbapi.h"
#include "config.h"
#include "dae.h"
#include "events.h"
#include "gxevents_util.h" 

char gxevents_version[] = "$Id: gxevents.c,v 1.9 2000/08/23 12:06:05 remlali Exp $"; /*usefull to 'strings' the binary*/

enum {
  EVENT_ID_IDX,
  EVENT_LV_IDX,
  EVENT_ST_IDX,
  EVENT_TS_IDX,
  EVENT_SR_IDX,
  EVENT_SU_IDX,
  EVENT_DS_IDX
};

/*******************************
** PROTOTYPES                 **
*******************************/

void fileacl_select();
void fileacl_hide();
void fileacl_load(GtkWidget *, GtkFileSelection *);
void subfileacl_select();
void subfileacl_hide();
void subfileacl_load(GtkWidget *, GtkFileSelection *);
static void     event_close_button_cb        (GtkWidget   *widget, gpointer    data);
static void     event_refresh_button_cb      (GtkWidget   *widget, gpointer    data);
static gint     event_panel_delete_cb        (GtkWidget   *widget, GdkEvent    *e, gpointer    data);
static void     fill_event_panel             (void);
static void     update_event_panel           (app_event    *event);

/*******************************
** GLOBALS                    **
*******************************/

/**** GUI *********************/
static GnomeUIInfo file_menu[] = {
  { GNOME_APP_UI_ITEM, N_("Save"), NULL,
    NULL, NULL, NULL, 
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save as..."), NULL, 
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },
  { GNOME_APP_UI_SEPARATOR },
  { GNOME_APP_UI_ITEM, N_("Print"), NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT, 0, 0, NULL },
  { GNOME_APP_UI_SEPARATOR },
  { GNOME_APP_UI_ITEM, N_("Close"), NULL, event_close_button_cb, 
    NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Exit"), NULL, event_close_button_cb,
    NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },
  { GNOME_APP_UI_ENDOFINFO },
};

static GnomeUIInfo edit_menu[] = {
  { GNOME_APP_UI_ITEM, N_("Load filter"), NULL,
    fileacl_select, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },

  { GNOME_APP_UI_ITEM, N_("Prune trap"), NULL,
    prune_trap, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },

  { GNOME_APP_UI_ITEM, N_("View trap"), NULL,
    tvw_open, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },

  { GNOME_APP_UI_ITEM, N_("Open filtered trap window"), NULL,
    subfileacl_select, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0, 0, NULL },

  { GNOME_APP_UI_ENDOFINFO },
};

static GnomeUIInfo *tools_menu;					/*run-time loaded from gxevents.conf, numerical is wc -l gxevents.conf*/

GnomeUIInfo event_panel_menu[] = {
  { GNOME_APP_UI_SUBTREE, N_("File"), NULL, file_menu, NULL, NULL, 
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_SUBTREE, N_("Edit"), NULL, edit_menu, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_SUBTREE, N_("Tools"), NULL, 0, NULL, NULL,		/*slot 2 MUST be Tools menu, moreinfo is overwritten when loading gxevents.conf*/
    GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
  { GNOME_APP_UI_ENDOFINFO },
};

GdkVisual *visual;
GdkColormap *colormap;
GdkColor black  =  { 0x0000,0x0000,0x0000,0x0000};		/*text*/
GdkColor red    =  { 0x0000,0xffff,0x0000,0x0000};		/*critical*/
GdkColor yellow =  { 0x0000,0xffff,0xffff,0x0000};		/*Alarm*/
GdkColor amber  =  { 0x0000,0xcccc,0xcccc,0x0000};		/*Warning*/
GdkColor green  =  { 0x0000,0x0000,0xffff,0x0000};		/*green*/
GdkColor white  =  { 0x0000,0xffff,0xffff,0xffff};              /*Informative*/
GdkColor grey   =  { 0x0000,0xafff,0xafff,0xafff};              /*Unknown*/

static GnomeUIInfo tools_menu_fail;			
       /*if load of gxevents.conf fails, set Tools menu to empty*/
GnomeUIInfo *toolsmenu;			
       /* if load success, we alloc space and fill her up */



/***** SUB EVENT_DISPLAY WINDOWS *****/

GList *sub_windows = NULL;

/***** TRAP VIEW WINDOW ******/

GtkWidget *tvw_win;
GtkWidget *tvw_vbox;
//GtkWidget *tvw_table;

/**** GXEVENT MENU *****/

menutoollist *menutools;        /* Dynamically loaded tools */

/******** UNSORTED **********/

int ddsock = 0;                 /*if ddsock is zero, we can't use database*/
FILE *tmpfp;
gchar *hostname_ptr;
gchar *ipaddr_ptr;
char line[400];
char line2[200];
char foo[200];
glb_enviroment enviroment;
static char pipestring[401];
static char mydpyfile[40];
static int mydpysock;
int dcsock;

/***** ACCESS CONTROL LIST ******/

GtkWidget *fileacl;
GtkWidget *subfileacl;
aclist *trapfilter = 0;		/* this is main displays trapfilter */
char aclfile[200];		/* main event_display loaded trapfilter filename */

/**** EVENT_DISPLAY  *****/

trapslot eventsel;		/*current selected event in eventlist*/
char textoid[400];		/*for eventsel*/
//int traplistcur = 0;		/*current pointer of first trap in traplist */
gint trapid = 0;		/*uniq ID of every Event */
static gchar *titles[] =
{
  "Event ID",
  "Category",
  "Status",
  "Timestamp",
  "Source",
  "Summary",
  "Description",0
};
static gint         col_sizes[6];
static event_panel *ev_panel = NULL;
static GList       *event_list = NULL;

/******************************
******************************/

void quit_cb(){
gint k;


  k = PDU_CLOSE;
  memcpy(line, &k, sizeof(gint));
  strcpy(line+sizeof(gint), mydpyfile);
  k = strlen(mydpyfile) + sizeof(gint);
  senddsocket(mydpysock, enviroment.evdpysrvd, line, k);
#if 0
  g_snprintf(line,400,"close %s",mydpyfile);
  sendsocket(mydpysock, enviroment.evdpysrvd, line);	/*tell evdpysrvd to disconnect trap receive pipe*/
#endif

  unlink(mydpyfile);
  printf("gxevents: unregistered to evdpysrvd.\n");
  dd_disconnect(ddsock);
  exit(0);
}

/* eventlist_cb()
*
* Fill in current selected event
* when user clicks on a event.
*/
void eventlist_cb(GtkWidget *eventlist, gint row, gint column, GdkEventButton *event){
gchar *field;
int a;
  GList     *item;
  app_event *data;

  gtk_clist_get_text(GTK_CLIST(eventlist), row, 0, &field);
  a = atoi(field);						/*get eventid*/
  item = g_list_first (event_list);
  while (item)							/*search up using eventid in app_events*/
    {
      data = (app_event *)item->data;
      if (data)
	if ( (data->eventid) == a)				/*ok, we've found the app_event*/
	  {
            strcpy(eventsel.IP,data->source);			/*fill in current selected event ( in main event window ) */
            //strcpy(eventsel.oid,data->oid);
            //eventsel.g = data->g;
            //eventsel.s = data->s;
            eventsel.severity = data->category;
            eventsel.timestamp = data->timestamp;
            gtk_clist_get_text(GTK_CLIST(eventlist), row, 6, &field);
            strcpy(eventsel.argoid[0], field);			/*argoid holds whole argument string*/
            break;
          }
      item = g_list_next (item);
    }
}

/***************************/

static void create_panel()
{
GtkWidget   *button;
GtkWidget   *scrolled;
GtkWidget   *w_frame;
GtkWidget   *vbox;
GtkWidget   *bar;
GtkWidget   *table;
GtkWidget   *button_box;
GtkWidget   *pixmap;
int         a, i, tmp, w_size;
gint        char_size;

  ev_panel = (event_panel *)g_malloc (sizeof (event_panel));
  ev_panel->window = gnome_app_new ("GXSNMP", _("Events"));

  gtk_signal_connect (GTK_OBJECT (ev_panel->window),
		      "delete_event",
		      GTK_SIGNAL_FUNC (event_panel_delete_cb),
		      NULL);

  vbox = gtk_vbox_new (FALSE, 4);
  table = gtk_table_new (3, 3, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 3);
  tmp = gdk_text_width (vbox->style->font, "1", 1);
  tmp = tmp * 18;
  w_size = 0;
  char_size = gdk_string_width (table->style->font, "xW") / 2;

  for (i=0; i< 6; i++){
      titles[i] = strdup(gettext(titles[i]));
      col_sizes[i] = strlen (titles[i]) * char_size;
  }

  ev_panel->clist =  gtk_clist_new_with_titles (7, titles);
  gtk_object_set_data (GTK_OBJECT (ev_panel->window), "event_clist", 
		       ev_panel->clist);

  gtk_clist_column_titles_passive (GTK_CLIST (ev_panel->clist));
  for (i = 0; i < 6; i++){
      gtk_clist_set_column_width (GTK_CLIST (ev_panel->clist), i, (col_sizes[i] + (col_sizes[i] / 2)));
      w_size += (col_sizes[i] + (col_sizes[i] / 2));
  }

  gtk_clist_set_selection_mode (GTK_CLIST (ev_panel->clist),  GTK_SELECTION_BROWSE);
  gtk_signal_connect(GTK_OBJECT(ev_panel->clist), "select_row",GTK_SIGNAL_FUNC(eventlist_cb),NULL);
  scrolled = gtk_scrolled_window_new (NULL, NULL);

  visual = gdk_visual_get_best();			/* initialize all list colors */
  colormap = gtk_widget_get_colormap(scrolled);
  gdk_color_alloc(colormap, &black);
  gdk_color_alloc(colormap, &red);
  gdk_color_alloc(colormap, &yellow);
  gdk_color_alloc(colormap, &amber);
  gdk_color_alloc(colormap, &green);
  gdk_color_alloc(colormap, &white);
  gdk_color_alloc(colormap, &grey);

  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled), 
			GTK_POLICY_ALWAYS, 
			GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scrolled), ev_panel->clist);
  gtk_table_attach (GTK_TABLE (table), scrolled, 0, 1, 0, 4,
		    GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 1);
  bar = gtk_vseparator_new ();
  gtk_table_attach (GTK_TABLE (table), bar, 1, 2, 0, 4,
		    GTK_FILL, GTK_FILL | GTK_EXPAND, 2, 1);
  button = gtk_button_new_with_label (_("Acknowledge"));
  gtk_object_set_data (GTK_OBJECT (ev_panel->window), "ack_button", button);
  gtk_widget_set_sensitive (button, FALSE);
  gtk_table_attach (GTK_TABLE (table), button, 
		    2, 3, 0, 1,
		    GTK_FILL | GTK_SHRINK, GTK_SHRINK, 1, 1);
  button = gtk_button_new_with_label (_("Delete"));
  gtk_object_set_data (GTK_OBJECT (ev_panel->window), "del_button", button);
  gtk_widget_set_sensitive (button, FALSE);
 /*
   * FIXME: need a way to determine the size of the buttons
   */
  w_size += (90 * 2);
  gtk_table_attach (GTK_TABLE (table), button,
		    2, 3, 1, 2,
		    GTK_FILL | GTK_SHRINK, GTK_SHRINK, 1, 1);
  bar = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), bar, FALSE, FALSE, 2);
  w_frame = gtk_frame_new (NULL);
  gtk_container_border_width (GTK_CONTAINER (w_frame), 2);
  gtk_box_pack_start (GTK_BOX (vbox), w_frame, FALSE, FALSE, 1);
  button_box = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (button_box),
			     GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (button_box), 2);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (button_box), 85, 20);
  gtk_container_border_width (GTK_CONTAINER (button_box), 2);
  gtk_container_add (GTK_CONTAINER (w_frame), button_box);

fprintf(stderr,"A");
//  button = gnome_stock_button ("close_button");
fprintf(stderr,"B");
  button = gnome_stock_button (GNOME_STOCK_BUTTON_CLOSE);
fprintf(stderr,"C");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (event_close_button_cb),
			NULL);
fprintf(stderr,"D");
  gtk_container_add (GTK_CONTAINER (button_box), button);
  pixmap = gnome_stock_pixmap_widget (ev_panel->window,
				      GNOME_STOCK_PIXMAP_REFRESH);
  button = gnome_pixmap_button (pixmap, _("Refresh"));
  gtk_signal_connect (GTK_OBJECT (button), "clicked", 
		      GTK_SIGNAL_FUNC (event_refresh_button_cb),
		      NULL);
  gtk_container_add (GTK_CONTAINER (button_box), button);

  fileacl = gtk_file_selection_new("Load Access Control List");
  gtk_signal_connect (GTK_OBJECT (fileacl), "destroy", (GtkSignalFunc) fileacl_hide, &fileacl);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fileacl)->ok_button), "clicked", (GtkSignalFunc) fileacl_load, fileacl );
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fileacl)->cancel_button), "clicked", (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (fileacl));

  subfileacl = gtk_file_selection_new("Load Access Control List");
  gtk_signal_connect (GTK_OBJECT (subfileacl), "destroy", (GtkSignalFunc) subfileacl_hide, &subfileacl);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (subfileacl)->ok_button), "clicked", (GtkSignalFunc) subfileacl_load, subfileacl );
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (subfileacl)->cancel_button), "clicked", (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (subfileacl));

/***** RUN-TIME LOAD THE TOOLS_MENU ********/

  tools_menu_fail.type = GNOME_APP_UI_ENDOFINFO; 

  strcpy(line,enviroment.base); /*sorry for putting file parsing here*/
  strcat(line,"/conf/gxevents.conf");
  if(!(tmpfp = fopen(line,"r"))){
    fprintf(stderr, "Can't access gxevents.conf file\n");
    event_panel_menu[2].moreinfo = &tools_menu_fail;
  }else{
    while(fgets(line,200,tmpfp)) i++;
    i++; i++; i++; 					/*last slot + some extra for safety*/
    if (!(toolsmenu = (GnomeUIInfo *) malloc((unsigned)(i*(sizeof(GnomeUIInfo)))))){
      fprintf(stderr, "Can't alloc enough space to hold your gxevents.conf setup\n");
      fclose(tmpfp);
      event_panel_menu[2].moreinfo = &tools_menu_fail;
    }else{
      if (!(menutools = (menutoollist *) malloc((unsigned)(i*(sizeof(menutoollist)))))){         
        fprintf(stderr, "Can't alloc enough space to hold your gxevents.conf setup\n");
        fclose(tmpfp);                                                                 
        event_panel_menu[2].moreinfo = &tools_menu_fail;
      }else{                                           
        fseek(tmpfp,0,SEEK_SET);
        for(a=0;fgets(line,200,tmpfp);){					/*lets build some menus*/
          if(line[0] == '#') continue;
          wordcpy(foo,line,1);							/*fetch name */
          wordcpy(line2,line,2);						/*fetch command */
          strcpy(menutools[a].name, foo);					/*set table that interpreter uses*/
          strcpy(menutools[a].cmd, line2);
          toolsmenu[a].type = GNOME_APP_UI_ITEM;
          toolsmenu[a].label = menutools[a].name;
          toolsmenu[a].hint = NULL;
          toolsmenu[a].moreinfo = menutools_interpret;
          toolsmenu[a].user_data = menutools[a].cmd;				/*bind command to set as argument to menutools_interpret()*/
          toolsmenu[a].unused_data = NULL;
          toolsmenu[a].pixmap_type = GNOME_APP_PIXMAP_STOCK;
          toolsmenu[a].pixmap_info = GNOME_STOCK_MENU_BLANK;
          toolsmenu[a].accelerator_key = 0;
          toolsmenu[a].ac_mods = 0;
          toolsmenu[a].widget = NULL;
          a++;
        }
      toolsmenu[a].type = GNOME_APP_UI_ENDOFINFO;
      tools_menu = toolsmenu;
      event_panel_menu[2].moreinfo = tools_menu;
      }
    }
  }
/*******************************************/

  gnome_app_set_contents (GNOME_APP (ev_panel->window), vbox);
  gnome_app_create_menus(GNOME_APP (ev_panel->window), 
			  event_panel_menu);
  gtk_widget_set_usize (ev_panel->window, w_size, 200);
  gtk_widget_show_all (ev_panel->window);
}

/* widget callbacks*/

static void event_close_button_cb (GtkWidget *widget, gpointer data)
{
  hide_event_panel ();
  quit_cb();
}

static void event_refresh_button_cb (GtkWidget *widget, gpointer data)
{
  fprintf(stderr,"this button is unsigned");
}

static gint event_panel_delete_cb (GtkWidget *widget, GdkEvent *e, gpointer data)
{
  destroy_event_panel();
  quit_cb();
  return 0;
}

/*
 * List management functions.
 */

static void fill_event_panel ()
{
  GList     *item;
  app_event *data;

  if (g_list_length <= 0)
      return;
  else
    {
      item = g_list_first (event_list);
      while (item)
	{
	  data = (app_event *)item->data;
	  if (data)
	    update_event_panel (data);
	  item = g_list_next (item);
	}
    }

}

int add_event (app_event *event)
{
  GList     *item;
  app_event  *cp,*low=0,*data;
  int a ,b;

  cp = (app_event *)g_malloc (sizeof (app_event));
  memcpy (cp, event, sizeof (app_event));		/*make a copy of incoming event*/
  cp->eventid = ++trapid;
  event_list = g_list_append (event_list, cp);
  b = g_list_length(event_list);
  while(b > enviroment.gxevents_max_traps){		/*adjust list to maximum amount of list items*/
    gtk_clist_remove(GTK_CLIST (ev_panel->clist), 0);	/*remove oldest entry in list*/
    item = g_list_first (event_list);			/*update g_list*/
    a = 65535;						/*maximum possible amount of list items ever*/
    while (item)
      {
        data = (app_event *)item->data;
        if (data)
          if (a > (data->eventid)){ 
            a = data->eventid;
            low = data;
          }
        item = g_list_next (item);
      }
    event_list = g_list_remove(event_list, low);
    g_free(low);
    b--;
  }
  update_event_panel(cp);
  return 1;
}

int remove_event (int eventid)
{
  GList     *item;
  app_event *data;

  item = g_list_first (event_list);
  while (item)
    {
      data = (app_event *)item->data;
      if (data)
	if ( (data->eventid) == eventid)
	  {
	    event_list = g_list_remove (event_list, data);
	    g_free (data);
	    return 1;
	  }
      item = g_list_next (item);
    }
  return -1;
}

/*
 * Exported standard panel functions.
 */
void open_event_panel ()
{
  if (!ev_panel)
    create_panel ();
  else
    if (!GTK_WIDGET_VISIBLE (ev_panel->window))
      gtk_widget_show (ev_panel->window);
  reset_event_panel ();
}

void destroy_event_panel ()
{
  if (ev_panel)
    {
      gtk_widget_destroy (ev_panel->window);
      g_free (ev_panel);
      ev_panel = NULL;
    }
	quit_cb();
}

void hide_event_panel ()
{
  if (ev_panel)
    {
      if (GTK_WIDGET_VISIBLE (ev_panel->window))
	{
	  gtk_widget_hide (ev_panel->window);
	}
    }
}

void reset_event_panel ()
{
  /* do any refresh of the panel that is needed, this is called when
   * the panel is opened.
   */
  gtk_clist_clear (GTK_CLIST (ev_panel->clist));
  fill_event_panel ();
}

/*
 * misc functions
 */
static void update_event_panel (app_event *event)
{
  char    t_buf[80];
  gchar    *list_item[8];
  int row;
  GdkColor *color;

  if (ev_panel)
    {
      if (GTK_WIDGET_VISIBLE (ev_panel->window))
	{
	  g_snprintf (t_buf, sizeof (t_buf), "%d", event->eventid);
	  list_item[EVENT_ID_IDX] = g_strdup (t_buf);
	  switch (event->sub_category)
	    {
	    case 1:
	      list_item[EVENT_LV_IDX] = g_strdup (_("Critical"));
              color = &red;
	      break;
	    case 2:
	      list_item[EVENT_LV_IDX] = g_strdup (_("Alarm"));
              color = &yellow;
	      break;
	    case 3:
	      list_item[EVENT_LV_IDX] = g_strdup (_("Warning"));
              color = &amber;
	      break;
	    case 4:
	      list_item[EVENT_LV_IDX] = g_strdup (_("Cleared"));
              color = &green;
	      break;
	    case 5:
	      list_item[EVENT_LV_IDX] = g_strdup (_("Informative"));
              color = &white;
	      break;

	    default:
	      list_item[EVENT_LV_IDX] = g_strdup ("Unknown");
              color = &grey;
	      break;
	    }
	  list_item[EVENT_ST_IDX] = g_strdup ("");
	  list_item[EVENT_TS_IDX] = g_strdup (ctime (&event->timestamp));
	  list_item[EVENT_SR_IDX] = g_strdup (event->source);
	  list_item[EVENT_SU_IDX] = g_strdup (event->summary);
	  list_item[EVENT_DS_IDX] = g_strdup (event->description);
	  row = gtk_clist_append (GTK_CLIST (ev_panel->clist), list_item);
          gtk_clist_set_foreground(GTK_CLIST (ev_panel->clist), row, &black );
          gtk_clist_set_background(GTK_CLIST (ev_panel->clist), row, color);
	}
    }
}

/*
 * Mainloop
 */

int main(int argc, char *argv[]){
aclist acl;
static int nbytes;
app_event event;
char    buf[200], buf2[1000],foo1[300];
g_trap trap;
gint k,known;
gchar *listitems[2]; 						/* this is for new trap windows */
time_t tk;
char *hostname;
int ddsize;
GList *swgl;
sub_window *subwin;
gchar *ctmp;
g_oid *goid;
gint category,n;

  load_enviroment();
  load_trapconf();						/*hold trap.conf loaded into enviroment.traptab */

/* load table-plugins and connect to database daemon */

  ddsock = db_server_connect_master("127.0.0.1", 4000);

/* connect to evdpysrvd and open a pipe */

  sprintf(mydpyfile,"/tmp/gxevents_socket_%u",time(0));
  unlink(mydpyfile);
  if(!(mydpysock = createsocket(mydpyfile,1))) return 1;	/*create a nonblocking connection to evdpysrvd*/
  printf("Using socket file %s\n",mydpyfile);
  aclfile[0] = 0;				/*set aclfile to state none loaded*/

  gnome_init("gxevents","0.0.11",argc,argv);
  open_event_panel();

  k = PDU_OPEN;
  memcpy(buf, &k, sizeof(gint));
  strcpy(buf+sizeof(gint), mydpyfile);
  k = strlen(mydpyfile) + sizeof(gint);
  senddsocket(mydpysock, enviroment.evdpysrvd, buf, k);
  printf("gxevents: registered to evdpysrvd.\n");
  //init_mib(); 					/*FIX: check if fail*/

  sub_windows = NULL; 			/*null terminate sub window list*/

start:

  if(gtk_events_pending()) gtk_main_iteration();
  pipestring[0] = 0;
  nbytes = recv(mydpysock,pipestring,400,0);
  if(nbytes == -1) goto start;

  if(!strncmp(pipestring,"gs.",3)){				/*hello received*/
    wordcpy(foo1,pipestring,2);				/*get evdpy struct ID*/
    g_snprintf(buf,200,"sr. %s",foo1);				/*make an answer*/
    sendsocket(mydpysock, enviroment.evdpysrvd, buf);	/*send alive response*/
    goto start;
  }

  memcpy(&category, pipestring, sizeof(gint));
fprintf(stderr,"Category(%u)\n", category);

  switch(category){

  case EVENT_SNMP_TRAP:
fprintf(stderr,"calling g_trap_decode()\n");
    g_trap_decode(pipestring,&trap);
    strcpy(acl.ip, trap.address);
    strcpy(acl.oid, trap.oid);
    acl.g = trap.g;
    acl.s = trap.s;
    trap.noid = 0;
    if(oid2text(&trap.noid, trap.oid)) trap.noid = trap.oid; /*translate OID, if fail, give OID as is */

/*Distribute event to all sub windows */
    swgl = sub_windows;
    while(swgl){
      subwin = swgl->data;
      if(subwin->acl){     /* Shouldn't happen, empty access list */
        printf("APP_ERR: no access control list loaded to a sub window trap display.\n");
        break;
      }
      if(!test_acl(acl, subwin->acl)) continue; /* check if event is allowed by filter */
      /* Create Event entry, and append it to sub window */
      g_snprintf(buf2,1000,"%s %s %d %d", trap.address, trap.noid, trap.g, trap.s);
      listitems[0] = buf2;
      listitems[1] = 0;
      gtk_clist_append(GTK_CLIST(subwin->sublist), listitems);
      swgl = swgl->next;
    }

    if(!test_acl(acl, trapfilter)) goto start;			/*check if event is allowed by filter*/

    trap_to_event(&trap, &event);

    add_event(&event);
  break;
  case EVENT_MESSAGE_SHORT:
    n = sizeof(gint); /* start after 'category' in packet */
    event.category = category;
    get_member(&n, pipestring, buf, &event.sub_category); /*get category*/
    get_member(&n, pipestring, buf, &k);                  /*get source */
    get_member(&n, pipestring, foo1, &k);                 /*get summary */
    get_member(&n, pipestring, buf2, &k); 	          /*get description */
    event.source = g_strdup(buf);
    event.summary = g_strdup(foo1);
    event.description = g_strdup(buf2);
    event.stat = 0;
    event.timestamp = time(0);
  break;
  } /*while category*/
  goto start;
}
