#include <stdio.h>
#include <gnome.h>

#include "dae.h"
#include "events.h"

/* trap_to_event()
*
* Fill in trap->name
* Fill in event struct using trap data.
* Make summary and description of event
*/
gint trap_to_event(g_trap *trap, app_event *event)
{
gchar buffer[1000], buf[200];
gint known = 0;
GList *gl;
g_oid *goid;
g_trap_context trap_ctx;

  memset(&trap_ctx, 0, sizeof(g_trap_context));
  event->source = trap->address;

  if(g_trap_lookup(trap, &trap_ctx)) /*check if trap is known by trap.conf */
    event->summary = g_strdup(trap_ctx.name);
  else if(trap->noid)
    event->summary = g_strdup(trap->noid);
  else if(trap->oid)
    event->summary = g_strdup(trap->oid);
  else
    event->summary = g_strdup("UNDEFINED");

  buffer[0] = 0;        
    strcat(buffer, "ARG: ");
    gl = trap->args;
    while(gl){
      goid = gl->data;
      sprintf(buffer, "Name: %s Data: %s", goid->name, goid->data);
      gl = gl->next;
    }
  event->description = g_strdup(buffer);
  event->category = EVENT_SNMP_TRAP;
  event->sub_category = trap->severity;
  event->stat = 0; 
  event->timestamp = trap->timestamp;
}
