#include <stddef.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/wait.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <gnome.h>
#include "dae.h"
#include "events.h"

#define EVPOLL 300 /*poll time gap when polling event displays*/

char version[] = "$Id: evdpysrvd.c,v 1.7 2000/07/23 01:08:25 remlali Exp $"; /*usefull to 'strings' the binary*/

/*GLOBALS	*/
typedef struct _xdpy{			/* Hold remote event display info*/
	gchar *address;		/* this is a file name when using AF_UNIX*/
	time_t lastpoll;	/* when did we last poll this evdpy*/
	gint state;		/* state of evdpy */
}xdpy;				

glb_enviroment enviroment;
int currt;						/*holds current time() */
FILE *fpevdpysrvd;
aclist *trapfilter;
int debug_level;
GList *xdpygl = NULL;		/* list of connected event displays */
/****************/

int debug(){return 0;}

/* about adding removing evdpy's
 * think if an remote machine has started its evdpy, it
 * should be listening on
 */

void xdpy_free(xdpy *dpy)
{
  g_free(dpy->address);
  g_free(dpy);
}

int xdpy_add(gchar *address){	/*adds an remote display to the xdpy-struct*/
xdpy *dpy;

  dpy = g_malloc(sizeof(xdpy));
  dpy->address = g_strdup(address);
  dpy->state = 1;		/* State is alive */
  dpy->lastpoll = currt;		/* last polled is current time */

  xdpygl = g_list_append(xdpygl, dpy);

}

int xdpy_del(gchar *address){	/*removes an remote display to the xdpy-struct*/
GList *gl;
xdpy *dpy;

  gl = xdpygl;

  while(gl){
    dpy = gl->data;
    if(!strcmp(dpy->address,address)){
      xdpygl = g_list_remove_link(xdpygl, gl);
      xdpy_free(dpy);
      return 1;
    }	
    gl = gl->next;
  }

}
void xdpy_reset(gchar *address)
{
GList *gl;
xdpy *dpy;

  gl = xdpygl;

  while(gl){
    dpy = gl->data;
    if(!strcmp(dpy->address,address)){
      dpy->state = 1;				/*far end evdpy is set to alive*/
      dpy->lastpoll = currt;			/*set date when we last polled */
      return 1;
    }	
    gl = gl->next;
  }

}

int main(){
gchar pipestring[4000];
gchar foo[1000],foo2[80];
gint evdpysrvdsock, nbytes;
gint i, traplen, pdutype;
GList *gl;
xdpy *dpy;
//trapslot trap;
g_trap trap;

/*daemonize*/
/*
  if(fork() != 0) _exit(0);
  if(setsid() == -1) _exit(0);
  if(fork() != 0) _exit(0);
  umask(777);
  if(chdir("/")<0) _exit(0);
  for(i=sysconf(_SC_OPEN_MAX),j=0;j<i;) close(j++);
  open("/dev/null",O_RDWR); dup(0); dup(0);
*/
/***********/
  load_enviroment();
  xdpygl = NULL;
  fpevdpysrvd = logopen("evdpysrvd.log");					/*start logging*/
  unlink(enviroment.evdpysrvd);
  if(!(evdpysrvdsock = createsocket(enviroment.evdpysrvd,0))) _exit(0);	/*trap input socket*/
  logstr(fpevdpysrvd,"Evdpysrvd started.\n");

start:
  currt = time(0);

  gl = xdpygl;
  while(gl){	/* go through all registered displays and check if they are alive*/
    dpy = gl->data;
    if(((currt - dpy->lastpoll)> EVPOLL) && dpy->state == 1){	
      /*this evdpy hasn't been polled for a while*/
      g_snprintf(foo,1000,"gs. %s", dpy->address);				/*GetStatus*/
      sendsocket(evdpysrvdsock, dpy->address, foo);
      dpy->state = 2;		/*pending state (evdpysrvd waiting for reply)*/
    }
    else if(((currt - dpy->lastpoll) > EVPOLL ) && dpy->state == 2){
      /*this evdpy hasn't answered a poll, within time 
        and it will be removed. */
      xdpy_del(dpy->address);
    }
    gl = gl->next;
  }

fprintf(stderr,"A\n");
  nbytes = recv(evdpysrvdsock,pipestring,400,0);
  if(nbytes < 0) goto start;
    if(!strncmp(pipestring,"kill",4)){
      unlink(enviroment.evdpysrvd);
      close(evdpysrvdsock);
      logstr(fpevdpysrvd,"Evdpysrvd stoped.\n");
      fclose(fpevdpysrvd);
      _exit(0);
    }

  memcpy(&pdutype, pipestring, sizeof(gint));
fprintf(stderr,"evdpysrvd:pdutype(%u)\n", pdutype);
  switch(pdutype){
  case PDU_OPEN:
    strcpy(foo, pipestring+sizeof(gint));		/*get source address ( IP / Socket  ) */
    xdpy_add(foo);
    g_snprintf(foo2,80,"Registered event display: %s\n",foo);
    logstr(fpevdpysrvd,foo2);
    fprintf(stderr,foo2);
  break;
  case PDU_CLOSE:
    strcpy(foo, pipestring+sizeof(gint));	/*get sorce address (IP/socket)*/
    xdpy_del(foo);			/*del old event display from receiveing traps*/
    g_snprintf(foo2,80,"Unregistered event display: %s\n",foo);
    logstr(fpevdpysrvd,foo2);
  break;
  case PDU_STATUS_REPLY:
    strcpy(foo,pipestring+sizeof(gint)+3);	/*get xdpy struct index */
    xdpy_reset(foo);
  break;
  case PDU_STATUS:
    strcpy(foo,"daemon evdpysrvd ");
    sendsocket(evdpysrvdsock, enviroment.gxdhd, foo);
    goto start;
  break;
#if 0
  case PDU_NETMON:
    memcpy(&netmon_msg, pipestring+sizeof(gint), sizeof(gint));
    memcpy(&netmon_host, pipestring+sizeof(gint)*2, sizeof(gint));
    memcpy(&netmon_addr, pipestring+sizeof(gint)*3, sizeof(gint));
    netmon_ip = inet_ntoa(netmon_addr);
    fprintf(stderr, "Host %d, IP %s, msg %u\n", netmon_host, netmon_ip, netmon_msg);
    senddsocket(trapdsock, enviroment.evdpysrvd, pipestring, nbytes);       

  break;
#endif
  case PDU_TRAP:
    traplen = g_trap_decode(pipestring, &trap);
    i = EVENT_SNMP_TRAP;
    memcpy(pipestring, &i, sizeof(gint));

    gl = xdpygl;
    while(gl){
      dpy = gl->data;
      g_snprintf(foo,1000,"Sending trap (%s,%d,%d) to display: %s\n",trap.oid,trap.g,trap.s,dpy->address);
      fprintf(stderr, foo);
      if(enviroment.evdpysrvd_log){
        logstr(fpevdpysrvd,foo);
      }
      senddsocket(evdpysrvdsock, dpy->address, pipestring, nbytes);
        /*forward event to connected event display */
      gl = gl->next;
    }
  break;
  default:
    /*unknown pdutype */
  break;
  } /* end of while pdutype */
  goto start;
  
}
