#include <unistd.h>
#include <stddef.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/wait.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <pthread.h>
#include <glib.h>
#include <EXTERN.h>
#include <perl.h>
#include <guile/gh.h>
#include <libguile.h>
#include "dae.h"
#include "corrd.h"

int debug_level;

extern void do_script(corrthreadslot *);

char corrd_version[] = "$Id: corrd.c,v 1.8 2000/07/23 01:08:25 remlali Exp $"; /*usefull to 'strings' the binary*/

/*perl things*/
static PerlInterpreter *perl = 0;
/*************/

/*Guile scheme things*/
/*********************/

char pipestring[400];
int corrdsock;
FILE *forkfp;
FILE *fpcorrd;
glb_enviroment enviroment;
aclist *trapfilter; /*this is only needed by the libdae*/
int pstatus, traplen;

GList *background, *bgs, *foreground, *fgs;
GList *corrthreads = 0; 	/* all corrthreadslots is saved in this list, for use by corrd */
int scheme_ct = 0; 		/* this is set, whenever there is a new trap to be correlated*/
corrthreadslot *newthread; 	/*this is a pointer to the trap to be correlated*/
struct timespec delay;

/* corr_lookup()
 *
 * return of this function is 
 * private for the function
 */
GList *corr_lookup(GList *fgs, fg_script **fgss, g_trap *trap){
fg_script *fg;

  while(fgs){
    fg = fgs->data;
    if(fg->ip[0] != 0) if(!strcmp(fg->ip, trap->address)) goto succ;
    if(fg->oid[0] != 0) if(!strcmp(fg->oid, trap->oid)) goto succ;
    if(fg->generic != 0) if(fg->generic == trap->g) goto succ;
    if(fg->specific != 0) if(fg->specific == trap->s) goto succ;
    fgs = fgs->next;
  }
  return 0;	/* end of foreground configuration file */

succ:	/* we found a match in foreground configuration file */
  *fgss = fgs->data;	/* return user data */
  fgs = fgs->next;	/* put us to next pointer in list */
  return fgs;
}

int main(int argc, char **argv, char** env){	/*needs argument due to PERL , but we pass NULLs anyway*/
char foo[80];
fg_script *corrdst;
int nbytes;
int l;
pthread_t sid;
g_trap trap;
g_trap_context trap_ctx;
/********/
typedef struct _trapbuf {
  gint type;
  gint severity;
  guint time;
  struct sockaddr_in address;
  guint generic;
  guint specific;
  gint  oidlen;
  gchar oid[130];
  gchar argbuf[10000];
} trapbuf;

trapbuf *gtrap;
/********/


GList *tmp;
fg_script *fgs;
gint pdutype;


/*daemonize*/
#if 0
  if(fork() != 0) _exit(0);
  if(setsid() == -1) _exit(0);
  if(fork() != 0) _exit(0);
  umask(777);
  if(chdir("/")<0) _exit(0);
  for(i=sysconf(_SC_OPEN_MAX),j=0;j<i;) close(j++);
  open("/dev/null",O_RDWR); dup(0); dup(0);
#endif
/***********/

fprintf(stderr,"loading env.\n");
  load_enviroment();
fprintf(stderr, "opening logfile\n");
  fpcorrd = logopen("corrd.log");

fprintf(stderr, "loading correlation configuration\n");
  /* loading file with DAE_BASE offset */
  if(corrd_config("/conf/corrd.conf", &background, &foreground)){
    fprintf(stderr,"Error loading configuration\n");
    exit(0);
  }

  fprintf(stderr,"Foreground config\n");
  tmp = foreground;
  while(tmp){
    fgs = tmp->data;
    fprintf(stderr,"File: %s\n", fgs->file);
    fprintf(stderr,"  ip: %s\n", fgs->ip);
    tmp = tmp->next;
  }
  fprintf(stderr,"background config\n");
  tmp = background;
  while(tmp){
    fgs = tmp->data;
    fprintf(stderr,"File: %s\n", fgs->file);
    tmp = tmp->next;
  }

fprintf(stderr, "binding socket to file: %s\n", enviroment.corrd);
  unlink(enviroment.corrd);
  if(!(corrdsock = createsocket(enviroment.corrd,0))) _exit(0);


/** startup perl **/
#if 0
  if((perl = perl_alloc()) == 0){
    perror("alloc");
    fprintf(stderr,"Can't correlate using perl_script\n");
    exit(1);    /* maybe we can live without perl? */
  }
  perl_construct(perl);
  perl_clear_env();
  perl_mutex = create_mutex(0);

  if((status = perl_run(perl)) != OK){
    exit(1);
  }
#endif
/******************/
 

  fprintf(stderr,"Corrd started.\n");
  logstr(fpcorrd,"Corrd started.\n");

start:

  nbytes = recv(corrdsock,pipestring,400,0);

  if(nbytes < 0) goto start;
  if(!strncmp(pipestring,"kill",4)){
    unlink(enviroment.corrd);
    close(corrdsock);
    logstr(fpcorrd,"Corrd stopped.\n");
    fclose(fpcorrd);
    _exit(0);
  }

  pdutype = (gint) pipestring[3];
  switch(pdutype){
  case PDU_STATUS: /*answer a hello query from gxstatus */
    nbytes = PDU_STATUS_REPLY;
    memcpy(pipestring, &nbytes, sizeof(gint));
    strcpy(pipestring+sizeof(gint), "corrd");
    senddsocket(corrdsock, enviroment.gxdhd, pipestring, sizeof("corrd")+sizeof(gint)+1);
  break;
  case PDU_RELOAD:
    corrd_config("/conf/corrd.conf", &background, &foreground);
    /*FIX free old config, if new config was successfully loaded */
    logstr(fpcorrd,"Reloaded conf/corrd.conf.\n");
  break;

  case PDU_TRAP:
    fprintf(stderr,"Trap received.\n");
    memset(&trap, 0, sizeof(g_trap));
    g_trap_decode(pipestring, &trap);
    gtrap = pipestring;

    fgs = foreground;	/* assign private pointer to configuration */
    while(fgs = corr_lookup(fgs, &corrdst, &trap)){ /* loop through each matching script */
      fprintf(stderr,"Trap identified.\n");
      newthread = g_new0(corrthreadslot, 1);   /*create a new corrthreadslot */
      newthread->stype = 0;                    /*default to shell script */
      newthread->traplen = nbytes;
      if(strncmp(corrdst->file,"/",1)){	
                /*if no root-path is set, try interpret and assign */
        l = strlen(corrdst->file);
        if(!strncmp(corrdst->file+l-3, ".pl", 3)){
          newthread->stype = 1; /* script type perl */
          sprintf(newthread->args[0],"%s/perl/%s",enviroment.base, corrdst->file);
          newthread->scriptargs[0] = newthread->args[0];
        } else if(!strncmp(corrdst->file+l-4, ".scm", 4)){
          newthread->stype = 2; /* script type scheme */
          sprintf(newthread->script,"%s/scheme/%s",enviroment.base,corrdst->file);
        } else {		/*undefined script type. Dont know what to do. */
          logstr(fpcorrd,"Couldn't exec correlation script: unknown script type without full path.\n");
          g_free(newthread);
          continue;
        }
      }else{              /*scriptfile have full pathname, its must be a shellscript */
        newthread->stype = 3;                  /* script type bourne shell*/
        strcpy(newthread->script, "/bin/sh");
        strcpy(newthread->args[0], newthread->script);
        strcpy(newthread->args[1], corrdst->file);
        newthread->scriptargs[0] = newthread->args[0];
        newthread->scriptargs[1] = 0;
      }

      if(enviroment.corrd_log) logstr(fpcorrd,"Launching correlation script.\n");

      /*corrthreads = g_list_append(corrthreads, newthread);*/	
      /*save it in corrd's thread lookup table, for all traps*/
      fprintf(stderr,"Calling script.\n");
      fprintf(stderr,"Running thread.\n");
      pthread_create(&sid, 0, &do_script, newthread);

/*something checking sid here*/

//      g_free(newthread); /*REMOVE when we have threads, and a trap GList revision function, that throws away old traps*/
    }/*end of corr.conf while */
  break;
  default:
  break;
  }/*switch pdutype */
  goto start;
}
