/*  $Id: init.c,v 1.1 2000/07/23 00:50:20 remlali Exp $
 *
 * Copyright 2000 Larry Liimatainen
 * init.c -- bootstraping table description information
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 *  init.c
 *
 */

/* Database description
   initialization code
*/

#include <stdio.h>
#include <glib.h>
#include "dbapi.h"
#include "ddserver.h"

extern G_sql_connection *dbhandler;
extern GList * table_desc;

void db_init_server_side(db_table_descriptor *table)
{
GList *gl, *gl2, *mgl, *tdgl;
DB_dbfieldconfig *dfc;
gchar sqlstr[2000];
gchar buffer[20000];
G_sql_query *sql;
gchar *oldtabn;
db_table_descriptor *tab;
db_field_descriptor *fie;
GList *ttd;     /*temporary table descriptors list */
gint *n;

fprintf(stderr,"Encoding SQL string\n");
fprintf(stderr,"Using table(%s)\n", table->name);
  encode_sql(table, 0, sqlstr, SQL_SELECT_ALL, 0, 0);
fprintf(stderr,"Sending query(%s)\n", sqlstr);
  if(!(sql = g_sql_query(dbhandler, sqlstr, strlen(sqlstr)))){
              /*FIX: Notify user, else he must timeout */
              return;
  }         
  tdgl = NULL;
fprintf(stderr,"Retreiving result and creating T/F\n");
  while(g_sql_next_row(sql)){
    dfc = g_malloc(sizeof(DB_dbfieldconfig));

    dfc->rowid = strtol(g_sql_field_pos(sql, 0),0,0);
    dfc->tablen = g_sql_field_pos(sql, 1);
    dfc->fieldn = g_sql_field_pos(sql, 2);
    dfc->fieldt = strtol(g_sql_field_pos(sql, 3),0,0);
    dfc->number = strtol(g_sql_field_pos(sql, 4),0,0);
    tdgl = db_init_tabdes_add(tdgl, dfc);
  }
fprintf(stderr,"Freeing result\n");
  g_sql_free_query(sql);
   
fprintf(stderr,"Sorting table/field descriptor list\n");
  db_init_sort_tabdes(tdgl);
fprintf(stderr,"Calculate table sizes\n");
  db_table_descriptor_calc_size(tdgl);
fprintf(stderr,"Calculate table offsets\n");
  db_table_descriptor_calc_offset(tdgl);

fprintf(stderr,"Printing T/F desc\n"); /* usefull debugging info */
  gl = tdgl;  
  while(gl){
    tab = gl->data;
    fprintf(stderr,"Tablename(%s)\n", tab->name);
    gl2 = tab->fields;
    while(gl2){
      fie = gl2->data;
      fprintf(stderr,"  fieldname(%s)offset(%d)type(%d)\n", fie->name, fie->offset, fie->type);
      gl2 = gl2->next;
    }
    gl = gl->next;
  }
fprintf(stderr,"Printing T/F desc done\n");

  table_desc = tdgl;
}

