/* event handling system, general library
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <glib.h>

#include <errno.h>
#include <fcntl.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/un.h>
#include <netinet/in.h>   
#include <arpa/inet.h>
#include <unistd.h>

#include "g_snmp.h"

#include "dae.h"

struct sockaddr_in ddserver;

extern glb_enviroment enviroment;
extern aclist *trapfilter;

extern void debug();

/*
Trap lookup functions, uses conf/trap.conf as database
*/

int trap_lookup(trapslot *trap){
int i=0;
  while(1){
    if(!strlen(enviroment.traptab[i].oid)){
      return 1;               /*not found*/
    }
/*DEBUG*fprintf(stdout,"CMP(%s,%s)\n",enviroment.traptab[i].oid, trap->oid);*/
    if(!strcmp(enviroment.traptab[i].oid,trap->oid) && enviroment.traptab[i].g == trap->g && enviroment.traptab[i].s == trap->s){
      strcpy(trap->script,enviroment.traptab[i].script);
      strcpy(trap->name,enviroment.traptab[i].name);
      strcpy(trap->popup,enviroment.traptab[i].popup);
      trap->eid = enviroment.traptab[i].eid;
      trap->flag = enviroment.traptab[i].flag;
      trap->severity = enviroment.traptab[i].severity;
      return 0;
    }
    i++;
  }
}

/****************************************************************************
 * Inter-daemon data transfer functions
 ***************************************************************************/

int createsocket(const char *filename, int flag){
struct sockaddr_un name;
int sock;
size_t size;

  sock = socket(PF_UNIX, SOCK_DGRAM, 0);
  if(sock < 0){ 
    perror("socket()");
    return 0;
  }
  name.sun_family = AF_UNIX;
  strcpy(name.sun_path, filename);
  size = (offsetof (struct sockaddr_un, sun_path) + strlen(name.sun_path) + 1);
  if(bind(sock,(struct sockaddr *) &name, size) < 0){ 
    perror("bind()");
    return 0;
  }
  if(flag) fcntl(sock, F_SETFL, O_NONBLOCK);
  return sock;	
}

int sendsocket(int sock, char *dst, char *text){
struct sockaddr_un name;
size_t size;
int nbytes;

  name.sun_family = AF_UNIX;
  strcpy(name.sun_path, dst);
  size = strlen(name.sun_path) + sizeof( name.sun_family);
  nbytes = sendto(sock, text, strlen(text) + 1, 0, (struct sockaddr *) &name, size);
  return 0;
}
int senddsocket(int sock, char *dst, char *data, size_t len){
struct sockaddr_un name;
size_t size;
int nbytes;

  name.sun_family = AF_UNIX;
  strcpy(name.sun_path, dst);
  size = strlen(name.sun_path) + sizeof( name.sun_family);
  nbytes = sendto(sock, data, len + 1, 0, (struct sockaddr *) &name, size);
  return 0;
}

int trap_decode(char *pipestring, trapslot *trap){
int pz = 5, k, traplen, ta;
struct in_addr ip;
int soi;

  memset(trap, 0, sizeof(trapslot));

  if((pipestring[5] != '\123')) return 0;
  pz += sizeof(char);

  memcpy(&(trap->severity), &(pipestring[pz]),sizeof(int));          /*severity*/
  pz +=sizeof(int);

  memcpy(&(trap->timestamp), &(pipestring[pz]),sizeof(int));          /*trap timestamp from block*/
  pz += sizeof(int);

  memcpy(&ip,&(pipestring[pz]),sizeof(struct in_addr));
  strcpy(trap->IP,inet_ntoa(ip));
  pz += sizeof(int);

  memcpy(&(trap->g),&(pipestring[pz]),sizeof(int));
  pz += sizeof(int);
  memcpy(&(trap->s),&(pipestring[pz]),sizeof(int));
  pz += sizeof(int);

  memcpy(&ta,&(pipestring[pz]),sizeof(int));
  pz += sizeof(int);
  if(ta>130) return 0; 				/*buffer overflow*/
  memcpy(trap->oid,&(pipestring[pz]),ta);
  trap->oid[ta] = 0;
  pz += ta;
  traplen = ta;

  for(k=0;3>k;k++){					/*process trap arguments, only 4 are supported*/
    if(pipestring[pz] == '\xff'){ 			/*end of block*/
      traplen += sizeof(char); 
      break;
    }
    memcpy(&ta,&(pipestring[pz]),sizeof(int));    	/* var OID len */
    pz += sizeof(int);
    if(ta > 130) ta = 130;				/*OID shouldn't exceed 128bytes, better be paranoid than core dump*/
    memcpy(trap->argoid[k],&(pipestring[pz]),ta);    	/*get oid string*/
    trap->argoid[k][ta] = 0;
    pz += ta;
    traplen += ta + sizeof(int) + sizeof(char) + sizeof(char); /*OID + OID_len + EndOfBlock + value type */
    switch(pipestring[pz]){                    
    case 1:                    				/*32bit unsigned counter*/
      pz += sizeof(char);
      memcpy(&ta,&(pipestring[pz]),sizeof(int));	/* var value type len*/
      pz += sizeof(int);
      memcpy(&soi,&(pipestring[pz]),ta);      		/* var value */
      snprintf(trap->argdat[k],200,"%u",soi);
      pz += ta;
      traplen += sizeof(int) + ta;
      break;
    case 2:                                         	/* ASCIIZ */
      pz += sizeof(char);
      memcpy(&ta,&(pipestring[pz]),sizeof(int));      	/* var value type len */
      pz += sizeof(int);
      if(ta > 200) ta = 200;				/*exceeded buffer limit*/
      memcpy(trap->argdat[k],&(pipestring[pz]),ta);    	/* var value */
      trap->argdat[k][ta] = 0;
      pz += ta;
      traplen += sizeof(int) + ta;
      break;
    default:                				/* unsupported trap type */
      fprintf(stderr,"Unsupported trap type (oid: %s)\n",trap->argoid[k]);
      trap->argoid[k][0] = 0;				/*reset OID that contains a nonsupported data*/
      break;
    }
  }
  traplen += 10; 					/*safety*/
  return ++traplen;
}

