/* event handling system, general library
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <glib.h>

#include <errno.h>
#include <fcntl.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/un.h>
#include <netinet/in.h>   
#include <arpa/inet.h>
#include <unistd.h>

#include "g_snmp.h"

#include "dae.h"

char version[] = "$Id: dae.c,v 1.2 2000/01/31 20:16:20 remlali Exp $"; /*usefull to 'strings' the binary*/

struct sockaddr_in ddserver;

extern glb_enviroment enviroment;
extern aclist *trapfilter;

extern void debug();

char *load_file(char *filename)
{
char *text;
FILE *fp;
struct stat statb;

	if(!filename || !*filename){
		fprintf(stderr,"Empty filename");
		return 0;
	}

	if (stat(filename, &statb) == -1 || 
	    (statb.st_mode & S_IFMT) != S_IFREG || 
	    !(fp = fopen(filename, "r")))
	  {
	    if((statb.st_mode & S_IFMT) == S_IFREG) 
	      perror(filename);
	    else 
	      fprintf(stderr,"%s: not a regular file\n",filename);
	    return 0;
	}
	if (!( statb.st_size )) 
	  { 
	    text = (char *) NULL;
	    fclose(fp); 
	    return NULL;
	  }
	if (!(text = (char *) g_malloc((unsigned)(statb.st_size+1))))
	  {
	    fprintf(stderr, "Can't allocate enough memory\n");
	    fclose(fp); 
	    return 0;
	  }
	if (!fread(text, sizeof(char), statb.st_size+1, fp))
	  {
	    fprintf(stderr, "Couldn't read file\n");
	    g_free(text);
	    fclose(fp);
	    return 0;
	  }
	text[statb.st_size] = 0;
	fclose(fp);
	return text;
}

/****************************************************************************
 * SNMP Functions
 ***************************************************************************/
/*
 * converts oid to a text:
 * .1.3.6.1   -->   .internet.dod.org... 
 */
int 
oid2text(char *text, char *oidtext)
{
  gulong  name[SNMP_SIZE_OBJECTID];
  guint   name_len;
  
  name_len = SNMP_SIZE_OBJECTID;
  text[0];
  oidtext[0];
/*
  if (!read_objid(oidtext, name, &name_len))
    {
      return 1; 
    }
  sprint_objid(text, 200, name, name_len);
*/
  return 0;
}

/*
 * global functions
 */

char *make_pathname(char *base, char *name){
char *ptr;
int s;

	s = strlen(enviroment.base);
	s += strlen(name);
	if(!(ptr = (char *) malloc((unsigned)s+1))){
		fprintf(stderr,"Cant alloc memory for holding a filename\n");
	}
	ptr[0] = 0;
	strcpy(ptr ,enviroment.base);
	strcat(ptr,name);
	return ptr;
}

int load_enviroment(){
char line[200],entity[200],value[200];
char *env;
FILE *fp;

	env = getenv("DAE_BASE");
	if(!env) {
		fprintf(stderr,"Error: enviroment variable: DAE_BASE is not set.\n");
		exit(1); /*critical*/
	}

	enviroment.trapd_unknown_traps = 1;
	enviroment.trapd_log_unknown_traps = 1;
	enviroment.corrd_log = 1;
	enviroment.evdpysrvd_log = 1;
	enviroment.evdpysrvd_poll = 300;		/*default timeout/poll of event displays (in seconds) */
	enviroment.gxevents_max_traps = 100;		/*default number of traps gxevents will display before removing*/
	enviroment.gxevents_lookup = 1;			/*default don't lookup hostname from IP*/
        enviroment.popup_date = 0;			/*default to negative*/

	strcpy(line,env);
	strcat(line,"/conf/nb.conf");

	if(!(fp = fopen(line, "r"))) return 1;
	while(fgets(line,200,fp)){
		if(line[0] == '#') continue;
		wordcpy(entity,line,1);		/* first check if it is a define statement */
		if(!strcmp(entity,"CORRD_LOG")) enviroment.corrd_log = 1;
		else if(!strcmp(entity,"TRAP_UNKNOWN_TRAPS")) enviroment.trapd_unknown_traps = 1;
		else if(!strcmp(entity,"TRAP_LOG_UNKNOWN_TRAPS")) enviroment.trapd_log_unknown_traps = 1;
		else if(!strcmp(entity,"EVDPYSRVD_LOG")) enviroment.evdpysrvd_log = 1;
		else if(!strcmp(entity,"POPUP_DATE"))  enviroment.popup_date = 1;
		else if(!strcmp(entity,"GXEVENTS_LOOKUP"))  enviroment.gxevents_lookup = 1;
		else {
			wordcpyt(entity,line,"=",1);
			wordcpyt(value,line,"=",2);
			restrap(value);
			if(!strcmp("DATABASE_HOST",entity)) strcpy(enviroment.host, value);
			else if(!strcmp("DATABASE_NAME",entity)) strcpy(enviroment.name, value);
			else if(!strcmp("DATABASE_USER",entity)) strcpy(enviroment.user, value);
			else if(!strcmp("DATABASE_PASS",entity)) strcpy(enviroment.passwd, value);
			else if(!strcmp("BASE",entity))          strcpy(enviroment.base, value);
			else if(!strcmp("EVDPYSRVD_POLL",entity)) enviroment.evdpysrvd_poll = atoi(value);
			else if(!strcmp("TRAP_DEFAULT_SEVERITY",entity)) enviroment.severity = atoi(value);
			else if(!strcmp("POPUP_EXEC",entity))  enviroment.popup_exec = strdup(value);
			else if(!strcmp("GXEVENTS_MAX_TRAPS",entity))  enviroment.gxevents_max_traps = atoi(value);
		}
	}

	enviroment.actiond = make_pathname(enviroment.base, "/sockets/actiond");
	enviroment.corrd = make_pathname(enviroment.base, "/sockets/corrd");
	enviroment.crond = make_pathname(enviroment.base, "/sockets/crond");
	enviroment.evdpysrvd = make_pathname(enviroment.base, "/sockets/evdpysrvd");
	enviroment.gxdhd = make_pathname(enviroment.base, "/sockets/gxdhd");
	enviroment.pdud = make_pathname(enviroment.base, "/sockets/pdud");
	enviroment.trapd = make_pathname(enviroment.base, "/sockets/trapd");

	fclose(fp);
	return 0;
}

int load_trapconf(){
char line[200],foo[200];
char *filename = "./conf/trap.conf";
FILE *fp;
int i=0,f;

	strcpy(line,enviroment.base);
	strcat(line,"/conf/trap.conf");
	if(!(fp = fopen(line,"r"))) return 1;
	while(fgets(line,200,fp)) i++;
	i++; i++; i++;	/*this slot is the last empty + 2 for safety*/

	if (!(enviroment.traptab = (trap_slot *) malloc((unsigned)(i*(sizeof(trap_slot)))))){
		fprintf (stderr, "Can't alloc enough space for %s", filename);
		fclose (fp);
		return 1;
	}
	fseek(fp,0,SEEK_SET);
	i=0;
	while(fgets(line,200,fp)){
		if(line[0] == '#') continue;		/*skip remarks in trap.conf*/

		wordcpy(foo,line,1);			/*OID*/
		strcpy(enviroment.traptab[i].oid, foo);

		wordcpy(foo,line,2);			/*generic*/
		f = atoi(foo);
		enviroment.traptab[i].g = f;

		wordcpy(foo,line,3);			/*specific*/
		f = atoi(foo);
		enviroment.traptab[i].s = f;

		wordcpy(foo,line,4);			/* name (name found in mib)*/
		strcpy(enviroment.traptab[i].name, foo);

		wordcpy(foo,line,5);			/*Script*/
		strcpy(enviroment.traptab[i].script, foo);

		wordcpy(foo,line,6);			/*Popup*/
		strcpy(enviroment.traptab[i].popup, foo);

		wordcpy(foo,line,7);			/*EID*/
		f = atoi(foo);
		enviroment.traptab[i].eid = f;

		wordcpy(foo,line,8);			/*Flags*/
		f = atoi(foo);
		enviroment.traptab[i].flag = f;

		wordcpy(foo,line,9);			/*Severity*/
		f = atoi(foo);
		enviroment.traptab[i].severity = f;

		i++;
	}
	strcpy(enviroment.traptab[i].oid,"");		/*terminate*/
	fclose(fp);
	return 0;
}
corr_slot *load_corrconf(){
char line[200],foo[200];
char *filename = "./conf/corr.conf";
FILE *fp;
int i=0;
corr_slot *corret, *cortmp;

	strcpy(line,enviroment.base);
	strcat(line,"/conf/corr.conf");
	if(!(fp = fopen(line,"r"))) return 1;
	while(fgets(line,200,fp)) i++;
	i++; i++; i++;

	if (!(corret = (corr_slot *) malloc((unsigned)(i*(sizeof(corr_slot)))))){
		fprintf (stderr, "Can't alloc enough space for %s", filename);
		fclose (fp);
		return 1;
	}
	fseek(fp,0,SEEK_SET);
	cortmp = corret;
	while(fgets(line,200,fp)){
		if(line[0] == '#') continue;

		wordcpy(foo,line,1);	/*IP-mask*/
		strcpy(corret->mask, foo);

		wordcpy(foo,line,2);	/*corr file*/
		strcpy(corret->file, foo);


		corret++;
	}
	corret->file[0] = 0;
	fclose(fp);
	return cortmp;
}
