/*
 * utility functions for the gxevents
 *
 */

#include <gnome.h>
#include "gxsnmpdb.h"
#include "gxsnmpdbc.h"
#include "dae.h"
#include "gxevents_util.h"

extern sub_window sub_windows[10];
extern char aclfile[200];
extern GtkWidget *tvw_win, *tvw_vbox;
extern aclist *trapfilter;
extern trapslot eventsel;
extern char line[400];
extern char textoid[400];

/* menutools_interpret()
 *
 * execute a command from tools menu
 *
 */
void
menutools_interpret(GtkWidget *mti, gchar *text)
{
gchar cmd[200];
gchar ioo[80];
gchar *iarg[10];
int i=0,j=0;
pid_t pid;

  var_interpret(cmd, text, 200, &eventsel);
  wordcpy(ioo,cmd,1);
  iarg[j++] = ioo;
  for(;9>j;i++){
    if(cmd[i] == '\0') break;
    if(cmd[i] == ' '){
      cmd[i] = '\0';
      iarg[j++] = &cmd[i+1];
    }
  }
  iarg[j] = 0;
  if(!(pid = fork())){
    if(!(fork())) execv(ioo,iarg);
      _exit(0);
    }
  waitpid(pid,NULL,0);
}

void
tvw_close(GtkWidget *tvw)
{
  gtk_widget_destroy(tvw);
}

/* tvw_open()
 *
 * send selected trap to a own window
 */
void
tvw_open()
{
GtkWidget *foo;

  eventsel.name[0] = 0;                                 /*define some trapslot_clear() instead*/
  trap_lookup(&eventsel);

  tvw_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  tvw_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add(GTK_CONTAINER(tvw_win), tvw_vbox);
  gtk_widget_show(tvw_vbox);

  snprintf(line,400,"Object ID: %s",eventsel.oid);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  textoid[0] = 0;
  oid2text(textoid, eventsel.oid);
  snprintf(line,400,"Object ID: %s",textoid);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  snprintf(line,400,"Generic: %d",eventsel.g);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  snprintf(line,400,"Specific: %d",eventsel.s);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  snprintf(line,400,"Name: %s",eventsel.name);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  snprintf(line,400,"Source: %s",eventsel.IP);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  snprintf(line,400,"Severity: %d",eventsel.severity);
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  foo = gtk_label_new(eventsel.argoid[0]);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  snprintf(line,400,"Date: %s", ctime((time_t *)&eventsel.timestamp));
  foo = gtk_label_new(line);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  foo = gtk_button_new_with_label("Dismiss");
  gtk_signal_connect(GTK_OBJECT(foo), "clicked",GTK_SIGNAL_FUNC(tvw_close),NULL);
  gtk_misc_set_alignment (GTK_MISC (foo), 0, 0);
  gtk_box_pack_start (GTK_BOX (tvw_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  gtk_widget_show_all(tvw_win);
}

/* sub_close()
 *
 * 
 *
 */
void
sub_close(GtkWidget *win)
{ /*I wonder if win is the dismiss button widget, then for(;;) beneith is unecessery*/
int a=0;

  for(;sub_windows[a].stat;a++){
    if(sub_windows[a].win == win){
      gtk_widget_destroy(win);
      sub_windows[a].stat = 1;                           /*this slot is set to empty*/
      if(sub_windows[a].acl) g_free(sub_windows[a].acl); /*hmm doesn't g_free check if zero?*/
    }
  }
}

/* sub_open()
 *
 * open a sub trap display
 */
void
sub_open(sub_window *subw)
{
GtkWidget *sub_vbox;
GtkWidget *foo;
GtkWidget *mywin;

  subw->win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  sub_vbox = gtk_vbox_new (FALSE, 4);
  gtk_container_add(GTK_CONTAINER(subw->win), sub_vbox);
  gtk_widget_show(sub_vbox);

  foo = gtk_label_new("Loaded filter: test");
  gtk_box_pack_start (GTK_BOX (sub_vbox), foo, FALSE, FALSE, 0);

  subw->sublist = gtk_clist_new(1);
  /*gtk_signal_connect(GTK_OBJECT(subw->sublist), "select_row",GTK_SIGNAL_FUNC(xxx_cb),NULL);*/
  gtk_clist_set_selection_mode(GTK_CLIST(subw->sublist),GTK_SELECTION_SINGLE);
  gtk_clist_column_titles_hide(GTK_CLIST(subw->sublist));
  gtk_clist_set_column_width(GTK_CLIST(subw->sublist),0,200);

  mywin = gtk_scrolled_window_new(0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (mywin),  GTK_POLICY_ALWAYS,  GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (mywin), subw->sublist);
  gtk_box_pack_start (GTK_BOX (sub_vbox), mywin, FALSE, FALSE, 0);

  foo = gtk_button_new_with_label("Dismiss");
  gtk_signal_connect(GTK_OBJECT(foo), "clicked",GTK_SIGNAL_FUNC(sub_close),NULL);
  gtk_box_pack_start (GTK_BOX (sub_vbox), foo, FALSE, FALSE, 0);
  gtk_widget_show(foo);

  gtk_widget_show_all(subw->win);
}

/* prune_trap()
 *
 * this callback will prune the selected trap.
 * add it into current loaded ACL
 */
void
prune_trap()
{ 
aclist acl;

  if(!aclfile) return;                                                  /*no trapfilter loaded*/
  acl.action = 13;                                                      /*add 'deny oid+g+s'*/
  acl.g = eventsel.g;
  acl.s = eventsel.s;
  strcpy(acl.oid,eventsel.oid);
  acl_add_filter(acl, aclfile);
  /*reload trapfilter*/
  if(trapfilter) g_free(trapfilter);
  else fprintf(stderr,"APP_ERR: no trapfilter loaded, but aclfile is set\n");
  trapfilter = load_acl(aclfile);                                       /*load event display filter (trapfilter )*/
}

