#include <glib.h>
#include <guile/gh.h>
#include <libguile.h>
#include <pthread.h>
#include "dae.h"
#include "corrd.h"

extern char pipestring[400];
extern corrthreadslot *newthread;      /*this is a pointer to the trap to be correlated*/
extern int traplen;
extern int corrdsock;
extern glb_enviroment enviroment;

/********************************
* SCHEME PROCEDURES             *
********************************/
SCM gx_compare_trapvar(SCM ivar, SCM iip){      /* compare vars against trap-fields*/
char *var;
char *value;
        
  var = gh_scm2newstr(ivar, NULL);
  value = gh_scm2newstr(iip, NULL);
         
  if(!strcmp(var,"IP")){
    if(!strcmp(value,newthread->trap.IP)) return SCM_BOOL_T;
    else return SCM_BOOL_F;
  }
  else if(!strcmp(var,"OID")){
    if(!strcmp(value,newthread->trap.oid)) return SCM_BOOL_T;
    else return SCM_BOOL_F;
  }
  else if(!strcmp(var,"GENERIC")){
    if(!strcmp(value,newthread->trap.g)) return SCM_BOOL_T;
    else return SCM_BOOL_F;
  }
  else if(!strcmp(var,"SPECIFIC")){
    if(!strcmp(value,newthread->trap.s)) return SCM_BOOL_T;
    else return SCM_BOOL_F;
  }
  else {  /* syntax error */
  }
}
             
SCM gx_forward(){  /*this will forward trap to evdpysrvd*/
  newthread->flag |= 16;
}
             
SCM gx_block(){   /*this will block trap to beeing evdpysrvd*/
  newthread->flag &= CTSFMASK - 16;
}
           
SCM gx_get_trapvar(SCM var){ /*returns 'var' from trap*/
char *text;
             
  text = gh_scm2newstr(var, NULL); 
  if(!strcmp(text,"IP")){
    text = newthread->trap.IP;
    return gh_str2scm(text,strlen(text));
  }
  else if(!strcmp(text,"OID")){
    text = newthread->trap.oid;
    return gh_str2scm(text,strlen(text));
  }
  else if(!strcmp(text,"GENERIC")){
    return gh_long2scm(newthread->trap.g);
  }
  else if(!strcmp(text,"SPECIFIC")){
    return gh_long2scm(newthread->trap.s);
  }
  else{   /*syntax error*/
  }
}
             
SCM gx_change_severity(SCM var){ /*change severity of trap*/
char *text;
  text = gh_scm2newstr(var, NULL);
  newthread->trap.severity = atoi(text);
}

SCM gx_print(SCM var){
char *text;
  text = gh_scm2newstr(var, NULL);
  fprintf(stderr,"%s\n",text);
}
             
/********************************
* CORRELATION FUNCTIONS         *
********************************/
          
void scheme_main(int argc, char **argv){
  fprintf(stderr,"scm1");
  gh_new_procedure("gx_compare_trapvar", gx_compare_trapvar, 2, 0, 0);
  gh_new_procedure("gx_forward", gx_forward, 0, 0, 0);
  gh_new_procedure("gx_block", gx_block, 0, 0, 0);
  gh_new_procedure("gx_get_trapvar", gx_get_trapvar, 1, 0, 0);
  gh_new_procedure("gx_change_severity", gx_change_severity, 1, 0, 0);
  gh_new_procedure("gx_print", gx_print, 1, 0, 0);
  fprintf(stderr,"scm2:%s\n",((corrthreadslot *)argv[0])->script);
  gh_load( ((corrthreadslot *)argv[0])->script);                  /*load and execute a Scheme file*/
  fprintf(stderr,"scm3");
  if(newthread->flag & 16){ 					  /* script said to forward this trap */
    /*IF CHANGING TO THREADS PIPESTRING & TRAPLEN MUST BE SAVED IN NEWTHREAD INSTEAD */
    senddsocket(corrdsock, enviroment.evdpysrvd, pipestring, traplen);
  }
  g_free(argv[0]);	/* free newthread */
  pthread_exit(0);
//  _exit(0);
}
            

void do_script(corrthreadslot *newthread){

    gh_enter(1, &newthread, scheme_main);
    fprintf(stderr,"WARNING: guile.c:do_script()@gh_enter() returned.\n");
    _exit(0);
}
