/* load corrd configuration file using
 * gscanner wrapper ( lib/lex.c )
 *
 */
#include <stdio.h>
#include <glib.h>

#include "dae.h" 
#include "../include/corrd.h" 
#include "config_file.h"


#include "lex.h"

extern glb_enviroment enviroment;

GList *foreground = NULL;
GList *background = NULL;

fg_script *new_fg()
{
fg_script *fg;
	if(!(fg = malloc(sizeof(fg_script)))){
                fprintf(stderr,"malloc failed\n");
		return 0;
        }
	return fg;
}

static void
corrd_config_add_entry_back(gpointer key, gpointer value, fg_script *fgs)
{

  if(!(strcmp(key, "script")))
    fgs->file = g_strdup(config_node_get_string(value));
}

static void
corrd_config_add_entry(gpointer key, gpointer value, fg_script *fgs)
{

  if(!(strcmp(key, "script")))
    fgs->file = g_strdup(config_node_get_string(value));
  else if(!(strcmp(key, "ip")))
    fgs->ip = g_strdup(config_node_get_string(value));
  else if(!(strcmp(key, "oid")))
    fgs->oid = config_node_get_string(value);
  else if(!(strcmp(key, "generic")))
    fgs->generic = config_node_get_string(value);
  else if(!(strcmp(key, "specific")))
    fgs->specific = config_node_get_string(value);
}

static void
corrd_config_get_trig(gpointer key, gpointer value, gpointer user_data)
{
  CONFIG_NODE * node;
  fg_script *fgs, *fgs2;
  GList *tmp = NULL;

  if(!(fgs = new_fg()))
    return;
  node = config_node_lookup (value, "entry");
  if(!node)
	fprintf(stderr,"node is empty\n");
  config_node_foreach (node, corrd_config_add_entry, fgs);
  foreground = g_list_append(foreground, fgs);
}

static void
corrd_config_get_back(gpointer key, gpointer value, gpointer user_data)
{
  CONFIG_NODE * node;
  fg_script *fgs, *fgs2;
  GList *tmp = NULL;

  if(!(fgs = new_fg()))
    return;
  node = config_node_lookup (value, "entry");
  if(!node)
	fprintf(stderr,"node is empty\n");
  config_node_foreach (node, corrd_config_add_entry_back, fgs);
  background = g_list_append(background, fgs);
}

int corrd_config(gchar *config_file, GList **back, GList **fore)
{
gint i=0,n=0;
gint act;
gint *cnt;
lexrunst lex;
                        /* states */
gint last;          /* scr is if script is set, last is last entry made
                           eg. we need always a script set, but maybe only IP */
char lastscript[200];
char file[400];

GList *active = 0;
GList *tgl = NULL;
GList *bgl = NULL;

GList *tmp;
GList *block = NULL;

fg_script *fgs;

CONFIG_NODE * config = NULL;
CONFIG_NODE * node;

  strcpy(file, enviroment.base);
  strcat(file, config_file);
  fprintf(stderr,"Loading corrd's configuration file: %s\n", file);

  config = config_load(file);
  printf("Start of configuration file:\n");
  config_save(config, NULL);
  printf ("End of configuration file.\n");

  node = config_node_lookup(config, "triggered_scripts");
  config_node_foreach(node, corrd_config_get_trig, 0);

  node = config_node_lookup(config, "background_scripts");
  config_node_foreach(node, corrd_config_get_back, 0);
  
  *back = background;
  *fore = foreground;
  return 0;
}
