/* orb_func.c
 *
 * this file 
 * abstracts
 * usage of corba.
 *
 */

#include <stdio.h>
#include <orb/orbit.h>
#include <libgnorba/gnorba.h>
#include <gnome.h>

//#include "echo.h"
#include "orbhdl.h"

/* gxorb_init()
 *
 *
 */
int gxorb_init(orbhdl *hdl)
{
static int argc = 1;
static char *argv[0];
CORBA_char *cstr;
char *progname = "foobar";
static CosNaming_NameComponent name_component[4] = { {"GNOME", "subcontext"},
                                                 {"Servers", "subcontext"},
                                                 {"GxSNMP", "subcontext"},
                                                 {"echoclient", "server"} };
static CosNaming_Name name = {4, 4, name_component, CORBA_FALSE};
static CosNaming_NameComponent name_component2[3] = { {"GNOME", "subcontext"},
                                                 {"Servers", "subcontext"},
                                                 {"GxSNMP", "server"} };
static CosNaming_Name name2 = {3, 3, name_component2, CORBA_FALSE};

  argv[0] = progname; /* should be provided by orbhdl struct ? */

fprintf(stderr,"1");
  CORBA_exception_init (&hdl->ev);
fprintf(stderr,"2");
  hdl->orb = gnome_CORBA_init ("a simple socket client",
                            "0.1",
                            &argc,
                            argv,
                            0,
                            &hdl->ev);
fprintf(stderr,"3");

   hdl->nameserver = gnome_name_service_get();
fprintf(stderr,"4");
   hdl->gxsnmp = CosNaming_NamingContext_resolve (hdl->nameserver,
                                            &name2,
                                            &hdl->ev);
fprintf(stderr,"5");
   if (hdl->ev._major != CORBA_NO_EXCEPTION) {
       fprintf (stderr,
                "Error: could resolve object: %s\n",
                CORBA_exception_id(&hdl->ev));
       exit (1);
   }
  if(!hdl->gxsnmp) fprintf(stderr," gxsnmp is empty\n");
}

/* gxorb_close()
 *
 */
int gxorb_close(orbhdl *hdl)
{
  /* Clean up */
  CORBA_Object_release(hdl->gxsnmp, &hdl->ev);
  CORBA_Object_release((CORBA_Object)hdl->orb, &hdl->ev);
//  CORBA_free (hdl->nameserver);
  CORBA_exception_free (&hdl->ev);
}
