#include <gnome.h>
#include <stdio.h>
#include <orb/orbit.h>
#include <libgnorba/gnorba.h>
#include "echo.h"

//#include "echo-skelimpl.c"
//GxsnmpDb echo_client = CORBA_OBJECT_NIL;

extern POA_GxsnmpDb__vepv impl_GxsnmpDb_vepv;


POA_GxsnmpDb poa_echo_servant = { NULL, &impl_GxsnmpDb_vepv };

int main (int argc, char **argv)
{
CORBA_ORB orb;
CORBA_Environment ev;
CosNaming_NamingContext root;
CosNaming_NameComponent name_component2[3] = { {"GNOME", "subcontext"},
                                                 {"Servers", "subcontext"},
                                                 {"GxSNMP", "server"} };
CosNaming_NameComponent name_component[4] = { {"GNOME", "subcontext"},
                                                 {"Servers", "subcontext"},
                                                 {"GxSNMP", "subcontext"},
                                                 {"echoclient", "server"} };
CosNaming_Name name2 = {3, 3, name_component2, CORBA_FALSE};
CosNaming_Name name = {4, 4, name_component, CORBA_FALSE};
PortableServer_POA root_poa;
PortableServer_POA poa;
PortableServer_POAManager root_poa_manager;
CORBA_PolicyList policy_list = {0, 0, NULL};
CORBA_Object gxsnmp;
CORBA_Object obj;
//PortableServer_ObjectId objid = {0, sizeof("myEchoString"), "myEchoString"};
//PortableServer_ObjectId *objidret; 
CosNaming_NamingContext *root_name;
POA_GxsnmpDb *poa_echo;
CORBA_char *objref;

  CORBA_exception_init (&ev);

  orb = gnome_CORBA_init ("a simple socket client", 
                            "0.1", 
                            &argc, 
                            argv, 
                            GNORBA_INIT_SERVER_FUNC, 
                            &ev);
  poa = (PortableServer_POA) 
  CORBA_ORB_resolve_initial_references (orb, "RootPOA", &ev);
  if (ev._major != CORBA_NO_EXCEPTION) {
     fprintf (stderr, "Error: %s\n", CORBA_exception_id(&ev));
     exit (1);
  }

  PortableServer_POAManager_activate(PortableServer_POA__get_the_POAManager(poa, &ev), &ev);
  if (ev._major != CORBA_NO_EXCEPTION) {
     fprintf (stderr, "Error: %s\n", CORBA_exception_id(&ev));
     exit (1);
  }

  obj = impl_GxsnmpDb__create (poa, &ev);

  root = gnome_name_service_get ();
  CosNaming_NamingContext_bind (root, &name2, obj, &ev);
  if (ev._major != CORBA_NO_EXCEPTION) {
     fprintf (stderr, "Error: couldn't register object: %s\n", CORBA_exception_id(&ev));
      exit (1);
  }


  objref = CORBA_ORB_object_to_string(orb, obj, &ev);
  fprintf(stderr, "OBJECT(%s)\n", objref);


  CORBA_exception_free (&ev);
  fprintf(stderr,"Now waiting for requests...\n");
  gtk_main();
  exit(0);
}
