#include "echo.h"

/*** App-specific servant structures ***/
typedef struct
{
   POA_GxsnmpDb servant;
   PortableServer_POA poa;

}
impl_POA_GxsnmpDb;

/*** Implementation stub prototypes ***/
static void impl_GxsnmpDb__destroy(impl_POA_GxsnmpDb * servant,
				   CORBA_Environment * ev);

static GxsnmpDb_Gxobject *impl_GxsnmpDb_GxobjectDbLoad(impl_POA_GxsnmpDb *
						       servant,
						       GxsnmpDb_Gxobject *
						       obj,
						       CORBA_Environment *

						       ev);

/*** epv structures ***/
static PortableServer_ServantBase__epv impl_GxsnmpDb_base_epv = {
   NULL,			/* _private data */
   NULL,			/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GxsnmpDb__epv impl_GxsnmpDb_epv = {
   NULL,			/* _private */

   (gpointer) & impl_GxsnmpDb_GxobjectDbLoad,

};

/*** vepv structures ***/
POA_GxsnmpDb__vepv impl_GxsnmpDb_vepv = {
   &impl_GxsnmpDb_base_epv,
   &impl_GxsnmpDb_epv,
};

/*** Stub implementations ***/
GxsnmpDb
impl_GxsnmpDb__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GxsnmpDb retval;
   impl_POA_GxsnmpDb *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GxsnmpDb, 1);
   newservant->servant.vepv = &impl_GxsnmpDb_vepv;
   newservant->poa = poa;
   POA_GxsnmpDb__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_GxsnmpDb__destroy(impl_POA_GxsnmpDb * servant, CORBA_Environment * ev)
{
   PortableServer_ObjectId *objid;

   objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
   PortableServer_POA_deactivate_object(servant->poa, objid, ev);
   CORBA_free(objid);

   POA_GxsnmpDb__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

static GxsnmpDb_Gxobject *
impl_GxsnmpDb_GxobjectDbLoad(impl_POA_GxsnmpDb * servant,
			     GxsnmpDb_Gxobject * obj, CORBA_Environment * ev)
{
   GxsnmpDb_Gxobject *object;
   GxsnmpDb_GxobjectCtx *ctx;

   GxsnmpDb_DbTableHost *host;

/* lets print out object data,
   we so carefully built up in dbgx_obj.c :) */
  
  host = obj->obj._buffer;
  printf("dnsName: %s\n", host->dnsName); /* something wrong */
  printf("name: %s\n", host->name);
  
/* ok, input finish, process output, else we segfault */

  object = GxsnmpDb_Gxobject__alloc();

  object->ctx._maximum = 80;
  object->ctx._length = 0;
  object->ctx._buffer = CORBA_sequence_CORBA_char_allocbuf(80);

  object->obj._maximum = 80;
  object->obj._length = 0;
  object->obj._buffer = CORBA_sequence_CORBA_char_allocbuf(80);

  strcpy(object->obj._buffer, "foreignobject");

  return object;

}
