/*
 * this file contains 
 * wrapper functions.
 * it takes gxobject structs
 * and converts them into
 * corba interface structs
 * and send / receives 
 * corba interface structs
 * that get converted
 * back to gxobject structs
 *
 * dbgx_obj.c
 */

#include <stdio.h>
#include <orb/orbit.h>
#include <libgnorba/gnorba.h>
#include <gnome.h>

#include "echo.h"
#include "tables.h"
#include "orbhdl.h"



/* GxobjectDbLoad()
 * this is a wrapper
 * for the GxsnmpDb_GxobjectDbLoad()
 * corba function.
 * it converts context to a corba_object
 * and calls a plugin to convert
 * object data to the corba_object
 *
 */
gint GxobjectDbLoad(orbhdl *hdl, gxobject *obj)
{
  gint size;
  gxobject gxobj;
  gxobject_ctx gxctx;
  gxobject *gxobjp;
  gxobject_ctx *gxctxp;

  GxsnmpDb_Gxobject *oobjp;
  GxsnmpDb_GxobjectCtx *octxp;
  GxsnmpDb_Gxobject oobj;
  GxsnmpDb_GxobjectCtx octx;
  GxsnmpDb_DbTableHost *ohost;

  DB_host *host;

/* we don't bother about context for now */

  oobj.ctx._maximum = 80;
  oobj.ctx._length = 80;
  oobj.ctx._buffer = CORBA_sequence_CORBA_char_allocbuf(80);

/* convert gxobject obj to corba Gxobject */

  oobj.objnum = obj->objnum;
  oobj.type = obj->type;

  host_convert_from(obj, &oobj);

   oobjp = &oobj;
   ohost = oobjp->obj._buffer;
   printf("readback dnsName: %s\n", ohost->dnsName);
   printf("readback name: %s\n", ohost->name);


fprintf(stderr,"c");
  oobjp = GxsnmpDb_GxobjectDbLoad(hdl->gxsnmp, &oobj, &hdl->ev);
fprintf(stderr,"C");

  if(hdl->ev._major != CORBA_NO_EXCEPTION) {
    printf("we got exception %d from GxsnmpDb_GxobjectDbLoad()\n", hdl->ev._major);
    printf("Execption string: %s\n", CORBA_exception_id(&hdl->ev));
    return -1;
  }   

  return 0;
}
