#include <stdio.h>
#include <orb/orbit.h>
#include <libgnorba/gnorba.h>
#include <gnome.h>

#include "tables.h"
#include "db_filters.h"
#include "echo.h"
#include "orbhdl.h"

extern gxdb_tables db_tables;
extern gint dcsock;


/* Echo Object */
GxsnmpDb echo_client = CORBA_OBJECT_NIL;


int main (int argc, char **argv)
{
/******************************************/
static CosNaming_NameComponent name_component[4] = { {"GNOME", "subcontext"},
                                                 {"Servers", "subcontext"},
                                                 {"GxSNMP", "subcontext"},
                                                 {"echoclient", "server"} };
static CosNaming_Name name = {4, 4, name_component, CORBA_FALSE};
static CosNaming_NameComponent name_component2[3] = { {"GNOME", "subcontext"},
                                                 {"Servers", "subcontext"},
                                                 {"GxSNMP", "server"} };
static CosNaming_Name name2 = {3, 3, name_component2, CORBA_FALSE};

/******************************************/

orbhdl hdl; /* abstract orbit state information */

DB_host      host;
gxobject_ctx ctx;
gxobject     obj;
gxobject    *retobj;

CosNaming_NamingContext nameserver;

  gxorb_init(&hdl);
/**************************/


/* setup host */

  host.rowid = 0;
  host.created = g_strdup("2000-03-13");
  host.modified = g_strdup("2000-03-13");
  host.dns_name = g_strdup("harem.ericsson.se");
  host.name = g_strdup("harem");
  host.description = g_strdup("mainserver");
  host.contact = g_strdup("us");
  host.g_sqldb_private = 0;
  host.DB_interfaces = NULL;
  host.DB_graphs = NULL;
  host.application = 0;

/* setup object context */

  ctx.type = OBJ_DB_HOST;
  ctx.user = &db_host_find_by_name;
  *((gint *) db_find_by_rowid.args[0]) = &host.name;

/* setup object */

  obj.objnum = 0;
  obj.type = OBJ_DB_HOST;
  obj.ctx = &ctx;
  obj.obj = &host;

  GxobjectDbLoad(&hdl, &obj);

//  fprintf(stderr,"OBJ->OBJ(%s)\n", retobj->obj);

/*************************/

  fprintf(stderr,"close&exit\n");
  gxorb_close(&hdl);			/* "close" orbit */
  exit(0);
fprintf(stderr,"4");
  CORBA_Object_release(hdl.gxsnmp, &hdl.ev);
fprintf(stderr,"3");
  CORBA_Object_release((CORBA_Object)hdl.orb, &hdl.ev);
fprintf(stderr,"2");
//  CORBA_free (hdl.root);
fprintf(stderr,"1");
  CORBA_exception_free (&hdl.ev);
fprintf(stderr,"0");

}
