/* -*- Mode: C -*-
 *  $Id: gxsnmp_table_dialog.c,v 1.1 1999/11/07 20:22:34 jochen Exp $
 *  GXSNMP -- An snmp mangament application
 *  Copyright (C) 1998 Gregory McLean
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 *  SNMP table dialog
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gxsnmp_table_dialog.h"
#include "debug.h"
#include "gxsnmp_util.h"

struct _colinfo {
  gchar  *title;
  gulong *oid;
  gint    oidlen;
};

static const GtkTargetEntry drop_targets[] = {
  { "application/x-gxsnmp-oid", 0, 0 }
};

/******************************************************************************
 *
 *  Forward references
 *
 **/
static void	table_class_init        (GxSNMPTableDialogClass *klass);
static void	table_init              (GxSNMPTableDialog      *dialog);
static void	table_dialog_cb		(GnomeDialog		*dialog,
					 gint			 button,
					 gpointer		 data);
static void	table_drop		(GtkWidget		*widget,
					 GdkDragContext		*context,
					 gint			 x,
					 gint			 y,
					 GtkSelectionData	*sel_data,
					 guint			 info,
					 guint			 dtime,
					 gpointer		 data);
/******************************************************************************
 *
 *  gxsnmp_map_get_type ()
 *
 **/
GtkType
gxsnmp_table_dialog_get_type()
{
  static GtkType table_type = 0;
  D_FUNC_START;
  if (!table_type)
    {
      GtkTypeInfo table_info =
      {
        "GxSNMPTableDialog",
        sizeof (GxSNMPTableDialog),
        sizeof (GxSNMPTableDialogClass),
        (GtkClassInitFunc) table_class_init,
        (GtkObjectInitFunc) table_init,
        /* reserved 1 */ NULL,
        /* reserved 2 */ NULL,
	(GtkClassInitFunc) NULL,
      };
      table_type = gtk_type_unique (gnome_dialog_get_type (), &table_info);
    }
  D_FUNC_END;
  return table_type;
}

/******************************************************************************
 *
 *  The class initialization subroutine
 *
 **/
static GnomeDialog *parent_class;

static void
table_class_init (GxSNMPTableDialogClass *klass)
{
  D_FUNC_START;
  
  parent_class = gtk_type_class (gnome_dialog_get_type ());

  D_FUNC_END;
}
/*****************************************************************************
 *
 *  The widget initialization subroutine
 *
 **/
static void
table_init (GxSNMPTableDialog *dialog)
{
  GtkWidget * table;
  D_FUNC_START;
  g_return_if_fail (dialog != NULL);
  g_return_if_fail (GXSNMP_IS_TABLE_DIALOG (dialog));
  /* 
   *  Do the widget type initialization.
   */
  table = gtk_table_new (1, 2, FALSE);
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox),
		      table, TRUE, TRUE, 0);
  dialog->label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table), dialog->label, 0, 1, 0, 1, 0, 0, 0, 0);
  gtk_widget_show (dialog->label);
  dialog->scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_set_border_width (GTK_CONTAINER (dialog->scrolled_win), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (dialog->scrolled_win),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_table_attach (GTK_TABLE (table), 
		    dialog->scrolled_win, 0, 1, 1, 2, 0, 0, 0, 0);
  gtk_widget_show (dialog->scrolled_win);
  gtk_widget_show (table);
  /* Button 0 */
  gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (dialog),
					  "Abort",
					  GNOME_STOCK_PIXMAP_STOP);
  /* Button 1 */
  gnome_dialog_append_button_with_pixmap (GNOME_DIALOG (dialog),
					  "Reload",
					  GNOME_STOCK_PIXMAP_REFRESH);
  /* Button 2 & 3 */
  gnome_dialog_append_buttons (GNOME_DIALOG (dialog),
			       GNOME_STOCK_BUTTON_CLOSE,
			       GNOME_STOCK_BUTTON_HELP,
			       NULL);
  gtk_signal_connect (GTK_OBJECT(dialog), "clicked",
		      GTK_SIGNAL_FUNC(table_dialog_cb), NULL);
  D_FUNC_END;
}
static void
gxsnmp_table_dialog_set_data(GxSNMPTableDialog *dialog, GSList *colinfo, 
			     gchar *title)
{
  gint        c_width;          /* Average width of a character */
  gint        c_height;         /* Average height of a character */
  gint        colnum, i;
  GtkWidget  *head;
  gchar     **coltitle;
  struct _colinfo *col;
  D_FUNC_START;
  dialog->title = title;
  dialog->colinfo = colinfo;
  gtk_label_set_text(GTK_LABEL(dialog->label), dialog->title);
  c_width  = gdk_string_width (dialog->label->style->font, "xW") / 2;
  c_height = dialog->label->style->font->ascent + 
	     dialog->label->style->font->descent;
  colnum = g_slist_length(colinfo);
  if (colnum)
    {
      coltitle = g_malloc(colnum * sizeof (gpointer));
      for (i=0;i<colnum;i++)
	{
	  col = (struct _colinfo*) colinfo->data;
	  coltitle[i] = col->title;
	  colinfo = colinfo->next;
	}
      dialog->clist = gtk_clist_new_with_titles (colnum, coltitle);
      g_free(coltitle);
      gtk_container_add (GTK_CONTAINER (dialog->scrolled_win), dialog->clist);
      gtk_widget_set_usize (dialog->clist, 80 * c_width , 25 * c_height);
      gtk_widget_show (dialog->clist);
      for (i=0;i<colnum;i++)
	{
	  head = gtk_clist_get_column_widget (GTK_CLIST(dialog->clist), i);
	  gtk_drag_dest_set (head, GTK_DEST_DEFAULT_ALL,
		drop_targets, ELEMENTS (drop_targets), GDK_ACTION_COPY);
	  gtk_signal_connect (GTK_OBJECT(head), "drag_data_received",
		(GtkSignalFunc) table_drop, dialog);
	}
    }
  D_FUNC_END;
}
static void
table_dialog_cb (GnomeDialog *dialog, gint button, gpointer data)
{
  gchar *tmp;
  D_FUNC_START;
  switch (button)
    {
    case 0:
      g_print ("Abort!\n");
      break;
    case 1:
      g_print ("Reload\n");
      break;
    case 2:
      gnome_dialog_close (GNOME_DIALOG (dialog));
      break;
    case 3:
      tmp = gnome_help_file_find_file ("gxsnmp", "table-help.html");
      if (tmp)
	{
	  gnome_help_goto (0, tmp);
	  g_free (tmp);
	}
      break;
    default:
      g_print ("Button %d hit!\n", button);
      break;
    }
  D_FUNC_END;
}
static void
table_drop (GtkWidget* widget, GdkDragContext* context, gint x, gint y,
	    GtkSelectionData* sel_data, guint info, guint dtime, gpointer data)
{
  gint x1, y1;
  gint colnum, i;
  GxSNMPTableDialog *dialog;
  D_FUNC_START;
  dialog = GXSNMP_TABLE_DIALOG(data);
  colnum = g_slist_length(dialog->colinfo);
  gdk_window_get_pointer (widget->window, &x1, &y1, NULL);
  g_print("X (%d) Y (%d), X1 (%d), Y1 (%d)\n", x, y, x1, y1);
  for (i=0;i<colnum;i++)
    {
      if (gtk_clist_get_column_widget (GTK_CLIST(dialog->clist), i) == widget)
	{
	  g_print("Make column %d indirect to %s\n", i, (gchar *)sel_data->data);
	}
    }
  gtk_drag_finish (context, TRUE, TRUE, dtime);
  D_FUNC_END;
}
/****************************************************************************
 *
 *  Public function to create a new table dialog.
 *
 **/
GtkWidget *
gxsnmp_table_dialog_new (GSList *colinfo, gchar *title)
{
  GxSNMPTableDialog * dialog;
  D_FUNC_START;
  dialog = gtk_type_new (gxsnmp_table_dialog_get_type ());
  gxsnmp_table_dialog_set_data(dialog, colinfo, title);
  D_FUNC_END;
  return GTK_WIDGET (dialog);
}
GtkWidget *
gxsnmp_table_dialog_new_from_node (SmiNode *node)
{
  GxSNMPTableDialog * dialog;
  GSList * colinfo;
  SmiNode * entry;
  SmiNode * child;
  gchar * title;
  struct _colinfo *col;
  D_FUNC_START;
  title = node->name;
  colinfo = NULL;
  entry = smiGetFirstChildNode(node); /* There can be only one :) */
  g_return_val_if_fail(entry, NULL);
  child = smiGetFirstChildNode(entry);
  while(child)
    {
      col = g_malloc(sizeof(struct _colinfo));
      col->title = child->name;
      colinfo = g_slist_append(colinfo, col);
      child = smiGetNextChildNode(child);
    }
  dialog = gtk_type_new (gxsnmp_table_dialog_get_type ());
  gxsnmp_table_dialog_set_data(dialog, colinfo, title);
  D_FUNC_END;
  return GTK_WIDGET (dialog);
}
/* EOF */
