/*
**  poprox_pop.c
**
**  Copyright 1996,1997 - Board of Trustees - University of Illinois - Urbana
**  Jason Wessel - jwessel@uiuc.edu Computing & Communications Services Office
**  All rights reserved. 
**
**  Copyright 1998 - Board of Trustees - University of Illinois at Chicago
**  John Schulien - jms@uic.edu Academic Computing and Communications Center
**  All rights reserved
**   
**  This program may be freely modified and distributed provided that this
**  copyright information is retained.
*/


#include "poprox.h"

/*
**  This file should encapsulate all of the POP-specific code in poprox.
**  It contains two subroutines:  poprox_user_pop, and poprox_msg_pop.
**  poprox_user_pop is used to obtain the username and first command
**  from the client, and poprox_msg_pop is used to send an error message
**  to the client and terminate.
*/

/*
**  The following subroutine may be called to send a fatal error 
**  message to the POP client.  errno should be valid at this point.
*/

void
poprox_msg_pop(msg)
int	msg;			/* Message number */
{
    switch(msg) {

    case PROXY_RC_SOCKET:
	poprox_msg("-ERR Error %d attempting to create remote socket", errno);
	break;
    case PROXY_RC_SOCKOPT:
	poprox_msg("-ERR Error %d from setsockopt on remote socket", errno);
	break;
    case PROXY_RC_BIND:
        poprox_msg("-ERR Error %d attempting to bind remote socket", errno);
	break;
    case PROXY_RC_RES_NAME:
        poprox_msg("-ERR Unable to resolve remote server name");
	break;
    case PROXY_RC_RES_ADDR:
	poprox_msg("-ERR Unable to resolve remote server address");
	break;
    case PROXY_RC_CONNECT:
	poprox_msg("-ERR Error %d attempting to connect to remote server",
	    errno);
	break;
    case PROXY_RC_DBOPEN:
	poprox_msg("-ERR Error opening mailbox database");
	break;
    case PROXY_RC_DBFIND:
        poprox_msg("-ERR Cannot locate your maildrop");
	break;
    case PROXY_RC_DBDATA:
        poprox_msg("-ERR Your maildrop database entry is invalid");
	break;
    }
    poprox_cleanup(0);		/* Clean up and exit */
}

/*
**  The following routine begins the proxy process for a POP session.  
**  First, send a herald to the POP client.  The POP client will reply 
**  with the first command.  The only two valid commands at this point 
**  are 'user' and 'quit'.  Once we receive a 'user' command, we return 
**  pointers to both the entire command, and to the entered username.
**  The username will be used to select a POP server to connect to, 
**  and the proxy routine will send the command to that server to begin
**  the authentication process.
**
**  We return 0 if we succeeded, and >0 if we failed
*/

int
poprox_user_pop(proxyhostname, timeout, command, username) 
char 		*  proxyhostname;	/* Name of the proxy host */
struct timeval	*  timeout;		/* Seconds before timeout */
char 		** command;		/* Place to put command */
char 		** username;		/* Place to put username */
{
    char line[MAXLINELEN + 1];		/* Read buffer */
    char *t;				/* Pointer to current token */
    
    poprox_msg("+OK POPROX (Version 2.0) at %s starting. <%d.%d@%s>",
	proxyhostname, getpid(), time((time_t *)0), proxyhostname);

    while (1) {				/* Main command loop begins here */
	if (poprox_fgets(line,		/* Read a line from the POP client */
			MAXLINELEN,	/* maximum line length */
			STDIN_FILENO,	/* Input file descriptor */
			timeout) 	/* Timeout period */
	    == NULL) {			/* If end of file received ... */
	syslog(LOG_INFO, "Ending session due to end of file condition");
	    poprox_msg("-ERR Ending session due to end of file condition");
	    return(1);			
	} 
	*command = (char *)malloc(strlen(line) + 1);  /* Copy entire line */
	strcpy(*command, line);			      /* for our caller */

	strlower(line);			/* Lower-case the entire line */
	t = strtok(line, " \t\n\r");	/* Isolate the first token */
	
	if (!strcmp(t, "quit")) {	/* If the command was 'quit' */
	    poprox_msg("+OK POP server at %s signing off.", proxyhostname);
	    poprox_cleanup(0);		/* Clean up and exit */
	}

	if (!strcmp(t, "user")) {	  /* If the command was 'user' */
	    t = strtok(NULL, " \t\n\r");  /* Isolate the next token */
	    if (!t) {		 	  /* If no user name given */
	    poprox_msg("-ERR Too few arguments for the user command.");
	    }
	    *username = (char *)malloc(strlen(t) + 1);  /* Copy username */
	    strcpy(*username, t);			/* for our caller */
	    return 0;			/* Return successfully */	
	}

	free(*command);			/* Release the bad command */
	poprox_msg("-ERR Unknown command: \"%s\"", t);
    }
}

