/*
**  poprox_misc.c
**
**  Copyright 1996,1997 - Board of Trustees - University of Illinois - Urbana
**  Jason Wessel - jwessel@uiuc.edu Computing & Communications Services Office
**  All rights reserved. 
**
**  Copyright 1998 - Board of Trustees - University of Illinois at Chicago
**  John Schulien - jms@uic.edu Academic Computing and Communications Center
**  All rights reserved
**   
**  This program may be freely modified and distributed provided that this
**  copyright information is retained.
*/


#include "poprox.h"

/*
**  This is a special version of fgets() that uses the basic unbuffered
**  read system call, and has timeout capability.
**
**  This subroutine can handle the case where a single input line
**  arrives as more than one read.  We keep issuing reads until either 
**  our buffer fills up, or the buffer contains a \n.  
**  We assume that the \n occurs at the end of a read.
**
**  Note that the third parameter is a file descriptor, NOT a (FILE *).
*/

char *
poprox_fgets(buf, len, fd, timeout)
char 		*buf;			/* Read buffer */
int		len;			/* Length of read buffer */
int 		fd;			/* File descriptor to read from */
struct timeval  *timeout;		/* Seconds until timeout occurs */
{
    fd_set      readfds;      		/* File descriptor set for reading */
    int		nfds;			/* Number of file descriptors */
    char 	*cp = buf;		/* Pointer to next output character */
    int		bytes;			/* Used to keep track of bytes read */
    int		rc;			/* Used to check return codes */

    memset(buf, 0, len);		/* Start by zeroing the buffer */
    len--;				/* Reserve the last byte for \0 */
    while (len) {			/* Loop until buffer is empty */
	nfds = FD_SETSIZE;              /* # of file descriptors in a set */
	FD_ZERO(&readfds);              /* Start with a null set */
	FD_SET(fd,&readfds);            /* Add the Client Socket to the set */
	rc = select(nfds, &readfds, 0, 0, timeout); /* Wait for some data */
	if (rc == 0) {                  /* If we timed out ... */
	    syslog(LOG_INFO, "Session closed due to timeout");
	    poprox_cleanup(0);          /* Clean up and exit */
	}
	if (rc < 0) {                   /* If we had an error */
	    syslog(LOG_INFO, "Session closed due to select error %d", errno);
	    poprox_cleanup(0);          /* Clean up and exit */
	}
	bytes = read(fd, cp, len);	/* Read some data from the client */
	if (bytes < 1) {                /* If an error occurred ... */
	    syslog(LOG_INFO, "Session closed due to read error %d", errno);
	    poprox_cleanup(0);          /* Clean up and exit */
	}
	cp += bytes;			/* Advance character pointer */
	len -= bytes;			/* Decrease bytes remaining */
	if (strstr(buf,"\n"))           /* Read until buffer contains \n */
	    break;                      /* Then break out of the loop */
    }
    return (buf);			/* Return the parsed string */
}

/*
**  A function to convert a string into lower case. POP likes lower case.
*/

void 
strlower (s)
char *s;
{
    while (*s) {
	if (isupper(*s))
	    *s = (char)tolower((int)*s);
	s++;
    }
}

/*
** And one to convert a string into upper case.  IMAP likes upper case.
*/

void
strupper(s)
char *s;
{
    while(*s) {
	if (islower(*s))
	    *s = (char)toupper((int)*s);
	s++;
    }
}

/*
**  A subroutine to append <crlf> to a message, send it to the client,
**  then flush the send.
*/

int
poprox_msg(va_alist)			/* Send a message to the client */
va_dcl					/* Additional optional parameters */
{
    va_list	ap;			/* Variable Argument List */
    int 	status;			/* POP status indicator */
    char 	*format;		/* Format string for the message */
    char        message[MAXLINELEN];	/* Message buffer */

    va_start(ap);			/* Initialize stdarg stuff */
    format = va_arg(ap, char *);	/* Get the format string */
    vsprintf(message,format,ap);	/* Format the message with varargs */
    va_end(ap);				/* Finished with varargs */
    (void)strcat(message, "\r\n");	/* Append the <CR><LF> */
    (void)fputs(message, stdout); 	/* Send the message to the client */
    (void)fflush(stdout);		/* Force send the message now */
    return(status);			/* Return the status code */
}

