/*
**  poprox_main.c
** 
**  Copyright 1996,1997 - Board of Trustees - University of Illinois - Urbana
**  Jason Wessel - jwessel@uiuc.edu Computing & Communications Services Office
**  All rights reserved. 
**
**  Copyright 1998 - Board of Trustees - University of Illinois at Chicago
**  John Schulien - jms@uic.edu Academic Computing and Communications Center
**  All rights reserved
**   
**  This program may be freely modified and distributed provided that this
**  copyright information is retained.
*/

#include "poprox.h"

/*
**  All globals should be defined here
*/

int debug = 0;			/* Global:  Debugging flag */

/*
**  Main program begins here 
*/

void main(argc, argv) 
int argc;
char **argv;
{

    char    	   *username;			 /* User-entered name */
    char	   *command;			 /* Command entered by user */
    char    	   *hostname;			 /* Target pop server name */
    char	   *database = DATABASE;	 /* Default database file */
    char	   clientname[MAXHOSTNAMELEN+1]; /* Addr. of client machine */
    char    	   proxyhost[MAXHOSTNAMELEN+1];  /* Name of proxy server */
    struct timeval timeout = {POP_TIMEOUT, 0};	 /* Seconds to time out */
    SOCKADDR_IN    peeraddr;			 /* Structure for peer addr. */
    int		   peeraddrlen;			 /* Length of above structure */
    int		   rc;				 /* Used to hold return code */
    int		   proxy;			 /* What we are proxying */    
    char	   **cpp;			 /* Pointer into argv */
    int		   i;				 /* Index variable */
    int		   port;			 /* Server port to connect to */

/*
**  Set up some signal handlers, open syslog, and attempt to determine
**  the name of the proxy machine host
*/

    signal(SIGTERM, poprox_signal);             /* Trap the SIGTERM signal */
    signal(SIGHUP, poprox_signal);              /* Trap the SIGHUP signal */

    openlog("poprox", LOG_PID, LOG_DAEMON);     /* Initialize syslog */

/*
**  Scale the argument list
*/

    proxy = PROXY_POP;                          /* Default: POP proxy */
    port  = DEFAULT_PORT;			/* Default port from poprox.h */
    debug = 0;					/* Turn off debugging flags */

    cpp  = argv;                                /* Pointer into list */
    i    = argc;                                /* Copy the argument count */
    cpp++; i--;					/* Skip the command name */
    while (i > 0) {				/* Search the argument list */
	if (!strcmp(*cpp, "-i")) {              /* IMAP behavior desired */
	    proxy = PROXY_IMAP;                 /* Yes - set the flag */
	    cpp++; i--;                         /* Go to the next flag */
        }
        else if (!strcmp(*cpp, "-p")) {		/* Port option? */
	    cpp++; i--;				/* Yes - Move to next token */
	    if (!i) {				/* If no port given */
		printf("-p option missing port number");
		exit(1);
	    }
	    port = atoi(*cpp);			/* Get the port number */
	    if (!port) {			/* If port is invalid */
		printf("port missing or invalid");
		exit(1);
	    }
	    cpp++; i--;
	}
	else if (!strcmp(*cpp, "-d")) {		/* Debugging wanted? */
	    debug = DEBUG_PACKETS;		/* Turn on debugging */
	    cpp++; i--;				/* Skip to next token */
	}
	else {
	    printf("Invalid parameter %s", *cpp);
	    exit(1);
	}
    }


/*
**  We want the name of the proxy machine for the herald
*/

    if (gethostname(proxyhost,                  /* Obtain the name of the */
		    MAXHOSTNAMELEN))            /* host of this program */
 	strcpy(proxyhost, "localhost");         /* or set a default name */

/*
**  Attempt to determine who has connected to us.  If we cannot determine  
**  this, set the connection name to "proxyhost".  This may happen if we 
**  invoke poproxd from the command line for testing purposes.
*/

    peeraddrlen = sizeof(peeraddr);		/* Initialize struct length */
    memset(&peeraddr, 0, peeraddrlen);		/* Zero the structure */
    getpeername(STDOUT_FILENO, 			/* Find the host name of */
		     &peeraddr,			/* whoever or whatever is */
		     &peeraddrlen);		/* connected to stdout */
    if (peeraddr.sin_addr.s_addr)		/* If we have an address */
	strcpy(clientname, (char *)		
	   inet_ntoa(peeraddr.sin_addr.s_addr)); /* Format internet address */
    else strcpy(clientname, "proxyhost");	 /* or insert dummy name */

/*
**  Run the protocol-specific subroutine to obtain the username and login
**  command from the client.
*/


    if (proxy == PROXY_POP)
	rc = poprox_user_pop(proxyhost, 	/* Obtain the username and */
			     &timeout, 		/* command from the client */
			     &command, 
			     &username);
    if (proxy == PROXY_IMAP)
	rc = poprox_user_imap(proxyhost,	/* Obtain the username and */
			     &timeout,		/* command from the client */
			     &command,
			     &username);	

    if (rc)					/* If we were unsuccessful */
	poprox_cleanup(0);			/* clean up and exit */

    rc = poprox_host(username,			/* Determine the correct */ 
		     database, 			/* pop server for this */
		     &hostname);		/* username */


    if (rc) {					/* Report any errors */ 
	if (proxy == PROXY_POP)
	    poprox_msg_pop(rc);	
	if (proxy == PROXY_IMAP)
	    poprox_msg_imap(rc);
    }

    syslog(LOG_INFO, "Opening session for %s between %s and %s",
	username, clientname, hostname);

    rc = poprox_proxy(hostname, 		/* Proxy the remote session */
		      port,  	
		      command, 
		      &timeout);  	

    if (proxy == PROXY_POP)			/* Send last message & exit */
	poprox_msg_pop(rc);
    if (proxy == PROXY_IMAP)
	poprox_msg_imap(rc);

}

/*
**  Cleanup and exit routines go here
*/

void poprox_cleanup(junk) 
     int junk;
{
    syslog(LOG_INFO, "Closing session");
    closelog();
    exit(0);
}

void poprox_signal(junk)
    int junk;
{
    syslog(LOG_INFO, "Session terminated due to receipt of signal");
    poprox_cleanup(junk);
}

