/*
**  poprox_host.c
**
**  Copyright 1996,1997 - Board of Trustees - University of Illinois - Urbana
**  Jason Wessel - jwessel@uiuc.edu Computing & Communications Services Office
**  All rights reserved. 
**
**  Copyright 1998 - Board of Trustees - University of Illinois at Chicago
**  John Schulien - jms@uic.edu Academic Computing and Communications Center
**  All rights reserved
**   
**  This program may be freely modified and distributed provided that this
**  copyright information is retained.
*/

#include "poprox.h"

#define SUFFIX ":maildrop"			/* Appended to username */

/*
**  Here is the subroutine that consults the user database
**
**  Return codes are as follows:
**
**  PROXY_RC_OK         -  The database lookup has succeeded
**  PROXY_RC_DBOPEN     -  Unable to open the database 
**  PROXY_RC_DBFIND     -  Unable to find user in database
**  PROXY_RC_DBDATA     -  Invalid :maildrop entry for user
**
*/

int
poprox_host(username, database, hostname)
char *username;			/* Name of the connecting user */
char *database;			/* Name of the database to check */
char **hostname;		/* Place to store hostname pointer */
{
    
    DB 	*dbp;			/* Pointer to the database structure */
    DBT key, data;		/* Key and data descriptors */
    char *keytext;		/* Pointer to key text */
    char *dp;			/* Used to traverse data result */
    int  dl;			/* Used to hold resulting data length */

    keytext = (char *)malloc(strlen(username) + strlen(SUFFIX) + 1);

    strcpy(keytext, username);	/* Start with the username */
    strcat(keytext, SUFFIX);	/* Append the suffix to the username */

    if (db_open(database,	/* Name of the database file */
	    DB_UNKNOWN, 	/* We'll take any kind of database */
	    DB_RDONLY,		/* Open the database read-only */
	    0,			/* The mode is irrelevant for reading */
	    NULL,		/* No special DB_ENV overrides needed */
	    NULL,		/* No special DB_INFO overrides needed */
	    &dbp)) {		/* The database pointer */
	syslog(LOG_INFO, "Error opening mailbox database %s", database);
	return PROXY_RC_DBOPEN;
    }				/* if an error occurs */

    memset(&key, 0, sizeof(DBT));	/* Clear the key descriptor */
    memset(&data, 0, sizeof(DBT));	/* Clear the data descriptor */
    key.data = keytext;			/* Set up the key text pointer */
    key.size = strlen(keytext); 	/* Set up the key text length */

    data.flags = DB_DBT_MALLOC;	/* Obtain data storage from malloc */

    if (dbp->get(dbp, 		/* Read record from database */
	     0,			/* No transaction ID needed */
	     &key,		/* Pointer to key structure */
	     &data, 		/* Pointer to data structure */
	     0)) {		/* No flags needed */
	syslog(LOG_INFO, "Cannot locate maildrop for %s", username);
	return PROXY_RC_DBFIND;
    }

/*
**  The database will have returned the maildrop in the form:
**
**	username@hostname
**
**  We need to parse the maildrop to pick out just the hostname.
*/

    dp = data.data;		/* p --> First byte of result */
    dl = data.size;		/* l  =  Length of result */

    while (dl && (*dp!='@')) {	/* Look for '@' or end of data */
	dp++;			/* To find the start of the */
	--dl;			/* hostname part of the field */
    }

    if (!dl) {			/* If we hit the end of data */
	syslog(LOG_INFO, "Invalid maildrop entry for %s", username);
	return PROXY_RC_DBDATA;
    }

    *hostname = (char *)malloc(dl);	/* Allocate storage for result */  
    strncpy(*hostname, dp + 1, dl - 1);	/* Copy the host name portion */
    (*hostname)[dl - 1] = '\0';		/* Zero-delimit the host name */

    free(key.data);		/* Finished with the key storage */
    free(data.data);		/* Finished with the data storage */

    dbp->close(dbp, 0);		/* Close the database file */

    return PROXY_RC_OK; 	/* Return the resulting data field */
}




