/*
**  poprox.h
**
**  Copyright 1996,1997 - Board of Trustees - University of Illinois - Urbana
**  Jason Wessel - jwessel@uiuc.edu Computing & Communications Services Office
**  All rights reserved. 
**
**  Copyright 1998 - Board of Trustees - University of Illinois at Chicago
**  John Schulien - jms@uic.edu Academic Computing and Communications Center
**  All rights reserved
**   
**  This program may be freely modified and distributed provided that this
**  copyright information is retained.
*/

#include <stdio.h>
#include <unistd.h>
#include <stddef.h>
#include <string.h>
#include <sys/param.h>
#include <sys/time.h>
#include <varargs.h>
#include <errno.h>

#ifdef __hpux
#include <sys/xti.h>
#else
#include <netinet/tcp.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>

#ifdef _AIX
#include <sys/select.h>
#endif

#include <sys/signal.h>
#include <syslog.h>

/*
**  The following is for the user database
*/

#include <db.h>
#define DATABASE "/etc/mail/mailboxes.db"

/*
**  I happen to like some of the Winsock conventions, and have used them.
*/

#ifndef _WINSOCKAPI_
#define INVALID_SOCKET (-1)
typedef u_int SOCKET;
typedef struct sockaddr_in SOCKADDR_IN;
#endif

/*
**  Here are some debugging options
*/

extern int debug;		/* The global debugging flag */
#define DEBUG_PACKETS  (1)	/* Log each packet (gulp) */

/*
**  Some more definitions ... buffer sizes and the like 
*/

#define PROXY_POP  (0)          /* Default is a POP proxy */
#define PROXY_IMAP (1)          /* We can also proxy an imap server */

#define POP_TIMEOUT	120	/* Seconds before connection timeout */
#define MAXLINELEN      1024	/* Maximum allowable line length */
#define DEFAULT_PORT	110 	/* Default port to connect to on pop server */
#define BUFSIZE		4096	/* Length of read/write buffer */

/*
**  Here are message numbers that correspond to return codes
*/

#define PROXY_RC_OK	  (0)  /* Operation completed successfully */
#define PROXY_RC_SOCKET   (1)  /* Unable to create a server socket */
#define PROXY_RC_SOCKOPT  (2)  /* setsockopt() failed on server socket */
#define PROXY_RC_BIND     (3)  /* Unable to bind the server socket */
#define PROXY_RC_RES_NAME (4)  /* Unable to resolve the server name */
#define PROXY_RC_RES_ADDR (5)  /* Unable to resolve the server address */
#define PROXY_RC_CONNECT  (6)  /* Error from select() on server socket */
#define PROXY_RC_DBOPEN   (7)  /* Error trying to open user database */
#define PROXY_RC_DBFIND   (8)  /* Unable to find user in user database */
#define PROXY_RC_DBDATA   (9)  /* Entry in user database is invalid */

/*
**  Main program
*/

extern void 	main(int, char **);

/*
**  Subroutines to simulate POP and IMAP sessions to obtain the username
*/

extern int	poprox_user_pop(char *, 	  /* Proxy hostname */
	    	    		struct timeval *, /* Timeout period */
		    		char **, 	  /* Place to store command */
		    		char **);	  /* Place to store username */

extern int	poprox_user_imap(char *,	   /* Proxy hostname */
				 struct timeval *, /* Timeout period */
				 char **,	   /* Place to store command */
				 char **);	   /* Place to store username */

/*
**  Subroutines to print error messages and terminate the proxy
*/

extern void	poprox_msg_pop(int);		/* Error number */
extern void	poprox_msg_imap(int);		/* Error number */

/*
**  Subroutine to determine the correct pop server for a user 
*/

extern int  	poprox_host(char *, 		/* Pointer to username */
			    char *,		/* Pointer to database name */
		     	    char **);		/* Place to store server name */


extern void 	poprox_cleanup(int); 		/* Clean up and exit */	
extern void	poprox_signal(int);		/* Signal handler */
extern int 	poprox_msg(); 			/* Send message to client */

/*
**  Subroutine to conduct the proxy operation
*/

extern int      poprox_proxy(char *,		/* Server name to connect to */
			     int,		/* Server port to connect to */
		    	     char *, 		/* Command to issue to server */
			     struct timeval *);	/* Timeout period */ 

/*
**  Subroutine to issue an fgets() with a timeout period
*/

extern char *   poprox_fgets(char *, 		/* Address of buffer */
			     int,       	/* Length of buffer */
		    	     int, 		/* File descriptor to read */
			     struct timeval *); /* Timeout period */

/*
**  Subroutines to convert a string into upper and lower case 
*/

extern void	strupper(char *);		/* Pointer to string */
extern void	strlower(char *);		/* Pointer to string */


